/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetCallAmt;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetExrcDt;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetExrcStyle;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetMbddTp;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetMtrtyDtOfUndrlyg;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetPrmAmt;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetPrmPmtDt;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetPutAmt;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetStrkPric;
import drr.projection.iso20022.jfsa.rewrite.trade.functions.GetTp;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__1;
import iso20022.auth030.jfsa.OptionBarrierLevel1Choice__1;
import iso20022.auth030.jfsa.OptionMultipleBarrierLevels1__1;
import iso20022.auth030.jfsa.OptionOrSwaption11__1;
import iso20022.auth030.jfsa.Schedule4__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice23Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptn1Default.class)
public abstract class GetOptn1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected GetCallAmt getCallAmt;
    @Inject
    protected GetExrcDt getExrcDt;
    @Inject
    protected GetExrcStyle getExrcStyle;
    @Inject
    protected GetMbddTp getMbddTp;
    @Inject
    protected GetMtrtyDtOfUndrlyg getMtrtyDtOfUndrlyg;
    @Inject
    protected GetPrmAmt getPrmAmt;
    @Inject
    protected GetPrmPmtDt getPrmPmtDt;
    @Inject
    protected GetPutAmt getPutAmt;
    @Inject
    protected GetStrkPric getStrkPric;
    @Inject
    protected GetTp getTp;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption11__1 evaluate(JFSATransactionReport drrReport) {
        OptionOrSwaption11__1 optn;
        OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption11__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(JFSATransactionReport var1);

    public static class GetOptn1Default
    extends GetOptn1 {
        @Override
        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(JFSATransactionReport drrReport) {
            OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, JFSATransactionReport drrReport) {
            Boolean ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = false;
            }
            Boolean ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getLower", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getLower()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = false;
            }
            Boolean ifThenElseResult2 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getUpper", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getUpper()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult2 = false;
            }
            optn = (OptionOrSwaption11__1.OptionOrSwaption11__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption11__1.builder().setTp(this.getTp.evaluate(drrReport)).setMbddTp(this.getMbddTp.evaluate(drrReport)).setExrcStyle(this.getExrcStyle.evaluate(drrReport)).setExrcDt(this.getExrcDt.evaluate(drrReport)).setStrkPric(this.getStrkPric.evaluate(drrReport)).setStrkPricSchdl(MapperS.of((Object)drrReport).mapC("getStrikePriceSchedule", jFSATransactionReport -> jFSATransactionReport.getStrikePriceSchedule()).mapItem(item -> {
                AmountAndDirection106__1 _ifThenElseResult2 = null;
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String _ifThenElseResult0 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", jFSATransactionReport -> jFSATransactionReport.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", jFSATransactionReport -> jFSATransactionReport.getStrikePriceCurrency()).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", jFSATransactionReport -> jFSATransactionReport.getStrikePriceCurrency()).get();
                    Boolean _ifThenElseResult1 = null;
                    if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        _ifThenElseResult1 = false;
                    }
                    _ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(_ifThenElseResult0).build()).setSgn(_ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
                }
                return MapperS.of((Object)Schedule4__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(_ifThenElseResult2).setDcml(ifThenElseResult3).build()).build());
            }).getMulti()).setCallAmt(this.getCallAmt.evaluate(drrReport)).setPutAmt(this.getPutAmt.evaluate(drrReport)).setPrmAmt(this.getPrmAmt.evaluate(drrReport)).setPrmPmtDt(this.getPrmPmtDt.evaluate(drrReport)).setMtrtyDtOfUndrlyg(this.getMtrtyDtOfUndrlyg.evaluate(drrReport)).setBrrrLvls(OptionBarrierLevel1Choice__1.builder().setSngl(SecuritiesTransactionPrice23Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getCurrency", barrierPrice -> barrierPrice.getCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build()).setDcml((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build()).setMltpl(OptionMultipleBarrierLevels1__1.builder().setLwrLvl(SecuritiesTransactionPrice23Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getLower", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getLower()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getLower", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getLower()).map("getCurrency", barrierPrice -> barrierPrice.getCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult1).build()).setDcml((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getLower", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getLower()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build()).setUpperLvl(SecuritiesTransactionPrice23Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getUpper", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getUpper()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getUpper", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getUpper()).map("getCurrency", barrierPrice -> barrierPrice.getCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult2).build()).setDcml((BigDecimal)MapperS.of((Object)drrReport).map("getBarrier", jFSATransactionReport -> jFSATransactionReport.getBarrier()).map("getUpper", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.getUpper()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build()).build()).build()).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

