/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetPutAmtDefault.class)
public abstract class GetPutAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ActiveOrHistoricCurrencyAnd5DecimalAmount evaluate(JFSATransactionReport drrReport) {
        ActiveOrHistoricCurrencyAnd5DecimalAmount putAmt;
        ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder putAmtBuilder = this.doEvaluate(drrReport);
        if (putAmtBuilder == null) {
            putAmt = null;
        } else {
            putAmt = putAmtBuilder.build();
            this.objectValidator.validate(ActiveOrHistoricCurrencyAnd5DecimalAmount.class, (RosettaModelObject)putAmt);
        }
        return putAmt;
    }

    protected abstract ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport var1);

    public static class GetPutAmtDefault
    extends GetPutAmt {
        @Override
        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport drrReport) {
            ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder putAmt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
            return this.assignOutput(putAmt, drrReport);
        }

        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder assignOutput(ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder putAmt, JFSATransactionReport drrReport) {
            putAmt = (ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder)this.toBuilder((RosettaModelObject)ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", jFSATransactionReport -> jFSATransactionReport.getPutAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPutCurrency", jFSATransactionReport -> jFSATransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build());
            return Optional.ofNullable(putAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

