/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.cftc.rewrite.trade.meta.CFTCPart45LegMeta;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.standards.iosco.cde.base.payment.PeriodicPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CFTCPart45Leg", builder=CFTCPart45LegBuilderImpl.class, version="6.25.3")
@RuneDataType(value="CFTCPart45Leg", model="drr", builder=CFTCPart45LegBuilderImpl.class, version="6.25.3")
public interface CFTCPart45Leg
extends CommonLeg {
    public static final CFTCPart45LegMeta metaData = new CFTCPart45LegMeta();

    public PartyIdentifierFormatEnum getPayerIdentifierFormat();

    public PartyIdentifierFormatEnum getReceiverIdentifierFormat();

    @Override
    public CFTCPart45Leg build();

    @Override
    public CFTCPart45LegBuilder toBuilder();

    public static CFTCPart45LegBuilder builder() {
        return new CFTCPart45LegBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCPart45Leg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCPart45Leg> getType() {
        return CFTCPart45Leg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.class, this.getSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerIdentifierFormat"), PartyIdentifierFormatEnum.class, (Object)this.getPayerIdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverIdentifierFormat"), PartyIdentifierFormatEnum.class, (Object)this.getReceiverIdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCPart45LegBuilderImpl
    extends CommonLeg.CommonLegBuilderImpl
    implements CFTCPart45LegBuilder {
        protected PartyIdentifierFormatEnum payerIdentifierFormat;
        protected PartyIdentifierFormatEnum receiverIdentifierFormat;

        @Override
        @RosettaAttribute(value="payerIdentifierFormat")
        @RuneAttribute(value="payerIdentifierFormat")
        public PartyIdentifierFormatEnum getPayerIdentifierFormat() {
            return this.payerIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifierFormat")
        @RuneAttribute(value="receiverIdentifierFormat")
        public PartyIdentifierFormatEnum getReceiverIdentifierFormat() {
            return this.receiverIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public CFTCPart45LegBuilder setPeriodicPayment(CommonPeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCPart45LegBuilder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            CommonPeriodicPayment ifThenElseResult = _periodicPayment == null ? null : (_periodicPayment instanceof CommonPeriodicPayment ? (CommonPeriodicPayment)CommonPeriodicPayment.class.cast(_periodicPayment) : null);
            return this.setPeriodicPayment(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CFTCPart45LegBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public CFTCPart45LegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule) {
            if (_notionalAmountSchedule != null) {
                this.notionalAmountSchedule.add(_notionalAmountSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CFTCPart45LegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule, int idx) {
            this.getIndex(this.notionalAmountSchedule, idx, () -> _notionalAmountSchedule.toBuilder());
            return this;
        }

        @Override
        public CFTCPart45LegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            if (notionalAmountSchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalAmountSchedules) {
                    this.notionalAmountSchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountSchedule")
        public CFTCPart45LegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            this.notionalAmountSchedule = notionalAmountSchedules == null ? new ArrayList() : (List)notionalAmountSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule) {
            if (_notionalQuantitySchedule != null) {
                this.notionalQuantitySchedule.add(_notionalQuantitySchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule, int idx) {
            this.getIndex(this.notionalQuantitySchedule, idx, () -> _notionalQuantitySchedule.toBuilder());
            return this;
        }

        @Override
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            if (notionalQuantitySchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalQuantitySchedules) {
                    this.notionalQuantitySchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantitySchedule")
        public CFTCPart45LegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            this.notionalQuantitySchedule = notionalQuantitySchedules == null ? new ArrayList() : (List)notionalQuantitySchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public CFTCPart45LegBuilder setNotionalCurrency(ISOCurrencyCodeEnum _notionalCurrency) {
            this.notionalCurrency = _notionalCurrency == null ? null : _notionalCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public CFTCPart45LegBuilder setTotalNotionalQuantity(BigDecimal _totalNotionalQuantity) {
            this.totalNotionalQuantity = _totalNotionalQuantity == null ? null : _totalNotionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CFTCPart45LegBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CFTCPart45LegBuilder setSettlementCurrency(ISOCurrencyCodeEnum _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CFTCPart45LegBuilder setSpread(PriceFormat _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public CFTCPart45LegBuilder setSpreadNotation(PriceNotationEnum _spreadNotation) {
            this.spreadNotation = _spreadNotation == null ? null : _spreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public CFTCPart45LegBuilder setSpreadCurrency(ISOCurrencyCodeEnum _spreadCurrency) {
            this.spreadCurrency = _spreadCurrency == null ? null : _spreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public CFTCPart45LegBuilder setQuantityUnitOfMeasure(String _quantityUnitOfMeasure) {
            this.quantityUnitOfMeasure = _quantityUnitOfMeasure == null ? null : _quantityUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public CFTCPart45LegBuilder setDirection2(Direction2Enum _direction2) {
            this.direction2 = _direction2 == null ? null : _direction2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantity")
        @RuneAttribute(value="notionalQuantity")
        public CFTCPart45LegBuilder setNotionalQuantity(BigDecimal _notionalQuantity) {
            this.notionalQuantity = _notionalQuantity == null ? null : _notionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public CFTCPart45LegBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public CFTCPart45LegBuilder setQuantityFrequency(FrequencyPeriodEnum _quantityFrequency) {
            this.quantityFrequency = _quantityFrequency == null ? null : _quantityFrequency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplier")
        @RuneAttribute(value="quantityFrequencyMultiplier")
        public CFTCPart45LegBuilder setQuantityFrequencyMultiplier(Integer _quantityFrequencyMultiplier) {
            this.quantityFrequencyMultiplier = _quantityFrequencyMultiplier == null ? null : _quantityFrequencyMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerIdentifier")
        @RuneAttribute(value="payerIdentifier")
        public CFTCPart45LegBuilder setPayerIdentifier(String _payerIdentifier) {
            this.payerIdentifier = _payerIdentifier == null ? null : _payerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifier")
        @RuneAttribute(value="receiverIdentifier")
        public CFTCPart45LegBuilder setReceiverIdentifier(String _receiverIdentifier) {
            this.receiverIdentifier = _receiverIdentifier == null ? null : _receiverIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CFTCPart45LegBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public CFTCPart45LegBuilder setNextFloatingReferenceResetDate(Date _nextFloatingReferenceResetDate) {
            this.nextFloatingReferenceResetDate = _nextFloatingReferenceResetDate == null ? null : _nextFloatingReferenceResetDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerIdentifierFormat")
        @RuneAttribute(value="payerIdentifierFormat")
        public CFTCPart45LegBuilder setPayerIdentifierFormat(PartyIdentifierFormatEnum _payerIdentifierFormat) {
            this.payerIdentifierFormat = _payerIdentifierFormat == null ? null : _payerIdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifierFormat")
        @RuneAttribute(value="receiverIdentifierFormat")
        public CFTCPart45LegBuilder setReceiverIdentifierFormat(PartyIdentifierFormatEnum _receiverIdentifierFormat) {
            this.receiverIdentifierFormat = _receiverIdentifierFormat == null ? null : _receiverIdentifierFormat;
            return this;
        }

        @Override
        public CFTCPart45Leg build() {
            return new CFTCPart45LegImpl(this);
        }

        @Override
        public CFTCPart45LegBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCPart45LegBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerIdentifierFormat() != null) {
                return true;
            }
            return this.getReceiverIdentifierFormat() != null;
        }

        @Override
        public CFTCPart45LegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CFTCPart45LegBuilder o = (CFTCPart45LegBuilder)other;
            merger.mergeBasic((Object)this.getPayerIdentifierFormat(), (Object)o.getPayerIdentifierFormat(), this::setPayerIdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReceiverIdentifierFormat(), (Object)o.getReceiverIdentifierFormat(), this::setReceiverIdentifierFormat, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCPart45Leg _that = (CFTCPart45Leg)this.getType().cast(o);
            if (!Objects.equals((Object)this.payerIdentifierFormat, (Object)_that.getPayerIdentifierFormat())) {
                return false;
            }
            return Objects.equals((Object)this.receiverIdentifierFormat, (Object)_that.getReceiverIdentifierFormat());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerIdentifierFormat != null ? ((Object)((Object)this.payerIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.receiverIdentifierFormat != null ? ((Object)((Object)this.receiverIdentifierFormat)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCPart45LegBuilder {payerIdentifierFormat=" + String.valueOf((Object)this.payerIdentifierFormat) + ", receiverIdentifierFormat=" + String.valueOf((Object)this.receiverIdentifierFormat) + "} " + super.toString();
        }
    }

    public static interface CFTCPart45LegBuilder
    extends CFTCPart45Leg,
    CommonLeg.CommonLegBuilder {
        @Override
        public CFTCPart45LegBuilder setPeriodicPayment(PeriodicPayment var1);

        @Override
        public CFTCPart45LegBuilder setNotionalAmount(BigDecimal var1);

        @Override
        public CFTCPart45LegBuilder addNotionalAmountSchedule(NotionalPeriod var1);

        @Override
        public CFTCPart45LegBuilder addNotionalAmountSchedule(NotionalPeriod var1, int var2);

        @Override
        public CFTCPart45LegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CFTCPart45LegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(NotionalPeriod var1);

        @Override
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(NotionalPeriod var1, int var2);

        @Override
        public CFTCPart45LegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CFTCPart45LegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CFTCPart45LegBuilder setNotionalCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCPart45LegBuilder setTotalNotionalQuantity(BigDecimal var1);

        @Override
        public CFTCPart45LegBuilder setFixedRate(BigDecimal var1);

        @Override
        public CFTCPart45LegBuilder setSettlementCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCPart45LegBuilder setSpread(PriceFormat var1);

        @Override
        public CFTCPart45LegBuilder setSpreadNotation(PriceNotationEnum var1);

        @Override
        public CFTCPart45LegBuilder setSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCPart45LegBuilder setQuantityUnitOfMeasure(String var1);

        @Override
        public CFTCPart45LegBuilder setDirection2(Direction2Enum var1);

        @Override
        public CFTCPart45LegBuilder setPeriodicPayment(CommonPeriodicPayment var1);

        @Override
        public CFTCPart45LegBuilder setNotionalQuantity(BigDecimal var1);

        @Override
        public CFTCPart45LegBuilder setFixingDate(ZonedDateTime var1);

        @Override
        public CFTCPart45LegBuilder setQuantityFrequency(FrequencyPeriodEnum var1);

        @Override
        public CFTCPart45LegBuilder setQuantityFrequencyMultiplier(Integer var1);

        @Override
        public CFTCPart45LegBuilder setPayerIdentifier(String var1);

        @Override
        public CFTCPart45LegBuilder setReceiverIdentifier(String var1);

        @Override
        public CFTCPart45LegBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public CFTCPart45LegBuilder setNextFloatingReferenceResetDate(Date var1);

        public CFTCPart45LegBuilder setPayerIdentifierFormat(PartyIdentifierFormatEnum var1);

        public CFTCPart45LegBuilder setReceiverIdentifierFormat(PartyIdentifierFormatEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.CommonPeriodicPaymentBuilder.class, (RosettaModelObjectBuilder)this.getPeriodicPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerIdentifierFormat"), PartyIdentifierFormatEnum.class, (Object)this.getPayerIdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverIdentifierFormat"), PartyIdentifierFormatEnum.class, (Object)this.getReceiverIdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CFTCPart45LegBuilder prune();
    }

    public static class CFTCPart45LegImpl
    extends CommonLeg.CommonLegImpl
    implements CFTCPart45Leg {
        private final PartyIdentifierFormatEnum payerIdentifierFormat;
        private final PartyIdentifierFormatEnum receiverIdentifierFormat;

        protected CFTCPart45LegImpl(CFTCPart45LegBuilder builder) {
            super(builder);
            this.payerIdentifierFormat = builder.getPayerIdentifierFormat();
            this.receiverIdentifierFormat = builder.getReceiverIdentifierFormat();
        }

        @Override
        @RosettaAttribute(value="payerIdentifierFormat")
        @RuneAttribute(value="payerIdentifierFormat")
        public PartyIdentifierFormatEnum getPayerIdentifierFormat() {
            return this.payerIdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifierFormat")
        @RuneAttribute(value="receiverIdentifierFormat")
        public PartyIdentifierFormatEnum getReceiverIdentifierFormat() {
            return this.receiverIdentifierFormat;
        }

        @Override
        public CFTCPart45Leg build() {
            return this;
        }

        @Override
        public CFTCPart45LegBuilder toBuilder() {
            CFTCPart45LegBuilder builder = CFTCPart45Leg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCPart45LegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerIdentifierFormat()).ifPresent(builder::setPayerIdentifierFormat);
            Optional.ofNullable(this.getReceiverIdentifierFormat()).ifPresent(builder::setReceiverIdentifierFormat);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCPart45Leg _that = (CFTCPart45Leg)this.getType().cast(o);
            if (!Objects.equals((Object)this.payerIdentifierFormat, (Object)_that.getPayerIdentifierFormat())) {
                return false;
            }
            return Objects.equals((Object)this.receiverIdentifierFormat, (Object)_that.getReceiverIdentifierFormat());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerIdentifierFormat != null ? ((Object)((Object)this.payerIdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.receiverIdentifierFormat != null ? ((Object)((Object)this.receiverIdentifierFormat)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCPart45Leg {payerIdentifierFormat=" + String.valueOf((Object)this.payerIdentifierFormat) + ", receiverIdentifierFormat=" + String.valueOf((Object)this.receiverIdentifierFormat) + "} " + super.toString();
        }
    }
}

