/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.meta.CommonTransactionInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommonTransactionInformation", builder=CommonTransactionInformationBuilderImpl.class, version="6.25.3")
@RuneDataType(value="CommonTransactionInformation", model="drr", builder=CommonTransactionInformationBuilderImpl.class, version="6.25.3")
public interface CommonTransactionInformation
extends RosettaModelObject {
    public static final CommonTransactionInformationMeta metaData = new CommonTransactionInformationMeta();

    public TradableOnTradingVenueEnum getTradableOnTradingVenue();

    public Boolean getUnderlierTradedOnTradingVenue();

    public String getUnderlierAssetTradingPlatformIdentifier();

    public String getInternalTradeIdentifier();

    public CommonTransactionInformation build();

    public CommonTransactionInformationBuilder toBuilder();

    public static CommonTransactionInformationBuilder builder() {
        return new CommonTransactionInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonTransactionInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonTransactionInformation> getType() {
        return CommonTransactionInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, (Object)this.getTradableOnTradingVenue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, (Object)this.getUnderlierTradedOnTradingVenue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlierAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("internalTradeIdentifier"), String.class, (Object)this.getInternalTradeIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonTransactionInformationBuilderImpl
    implements CommonTransactionInformationBuilder {
        protected TradableOnTradingVenueEnum tradableOnTradingVenue;
        protected Boolean underlierTradedOnTradingVenue;
        protected String underlierAssetTradingPlatformIdentifier;
        protected String internalTradeIdentifier;

        @Override
        @RosettaAttribute(value="tradableOnTradingVenue")
        @RuneAttribute(value="tradableOnTradingVenue")
        public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
            return this.tradableOnTradingVenue;
        }

        @Override
        @RosettaAttribute(value="underlierTradedOnTradingVenue")
        @RuneAttribute(value="underlierTradedOnTradingVenue")
        public Boolean getUnderlierTradedOnTradingVenue() {
            return this.underlierTradedOnTradingVenue;
        }

        @Override
        @RosettaAttribute(value="underlierAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlierAssetTradingPlatformIdentifier")
        public String getUnderlierAssetTradingPlatformIdentifier() {
            return this.underlierAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="internalTradeIdentifier")
        @RuneAttribute(value="internalTradeIdentifier")
        public String getInternalTradeIdentifier() {
            return this.internalTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="tradableOnTradingVenue")
        @RuneAttribute(value="tradableOnTradingVenue")
        public CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum _tradableOnTradingVenue) {
            this.tradableOnTradingVenue = _tradableOnTradingVenue == null ? null : _tradableOnTradingVenue;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierTradedOnTradingVenue")
        @RuneAttribute(value="underlierTradedOnTradingVenue")
        public CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
            this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlierAssetTradingPlatformIdentifier")
        public CommonTransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String _underlierAssetTradingPlatformIdentifier) {
            this.underlierAssetTradingPlatformIdentifier = _underlierAssetTradingPlatformIdentifier == null ? null : _underlierAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="internalTradeIdentifier")
        @RuneAttribute(value="internalTradeIdentifier")
        public CommonTransactionInformationBuilder setInternalTradeIdentifier(String _internalTradeIdentifier) {
            this.internalTradeIdentifier = _internalTradeIdentifier == null ? null : _internalTradeIdentifier;
            return this;
        }

        @Override
        public CommonTransactionInformation build() {
            return new CommonTransactionInformationImpl(this);
        }

        @Override
        public CommonTransactionInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonTransactionInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getTradableOnTradingVenue() != null) {
                return true;
            }
            if (this.getUnderlierTradedOnTradingVenue() != null) {
                return true;
            }
            if (this.getUnderlierAssetTradingPlatformIdentifier() != null) {
                return true;
            }
            return this.getInternalTradeIdentifier() != null;
        }

        public CommonTransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommonTransactionInformationBuilder o = (CommonTransactionInformationBuilder)other;
            merger.mergeBasic((Object)this.getTradableOnTradingVenue(), (Object)o.getTradableOnTradingVenue(), this::setTradableOnTradingVenue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlierTradedOnTradingVenue(), (Object)o.getUnderlierTradedOnTradingVenue(), this::setUnderlierTradedOnTradingVenue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlierAssetTradingPlatformIdentifier(), (Object)o.getUnderlierAssetTradingPlatformIdentifier(), this::setUnderlierAssetTradingPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInternalTradeIdentifier(), (Object)o.getInternalTradeIdentifier(), this::setInternalTradeIdentifier, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommonTransactionInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.tradableOnTradingVenue, (Object)_that.getTradableOnTradingVenue())) {
                return false;
            }
            if (!Objects.equals(this.underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) {
                return false;
            }
            if (!Objects.equals(this.underlierAssetTradingPlatformIdentifier, _that.getUnderlierAssetTradingPlatformIdentifier())) {
                return false;
            }
            return Objects.equals(this.internalTradeIdentifier, _that.getInternalTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradableOnTradingVenue != null ? ((Object)((Object)this.tradableOnTradingVenue)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierTradedOnTradingVenue != null ? this.underlierTradedOnTradingVenue.hashCode() : 0);
            _result = 31 * _result + (this.underlierAssetTradingPlatformIdentifier != null ? this.underlierAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.internalTradeIdentifier != null ? this.internalTradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommonTransactionInformationBuilder {tradableOnTradingVenue=" + String.valueOf((Object)this.tradableOnTradingVenue) + ", underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue + ", underlierAssetTradingPlatformIdentifier=" + this.underlierAssetTradingPlatformIdentifier + ", internalTradeIdentifier=" + this.internalTradeIdentifier + "}";
        }
    }

    public static interface CommonTransactionInformationBuilder
    extends CommonTransactionInformation,
    RosettaModelObjectBuilder {
        public CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum var1);

        public CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean var1);

        public CommonTransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String var1);

        public CommonTransactionInformationBuilder setInternalTradeIdentifier(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, (Object)this.getTradableOnTradingVenue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, (Object)this.getUnderlierTradedOnTradingVenue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlierAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("internalTradeIdentifier"), String.class, (Object)this.getInternalTradeIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommonTransactionInformationBuilder prune();
    }

    public static class CommonTransactionInformationImpl
    implements CommonTransactionInformation {
        private final TradableOnTradingVenueEnum tradableOnTradingVenue;
        private final Boolean underlierTradedOnTradingVenue;
        private final String underlierAssetTradingPlatformIdentifier;
        private final String internalTradeIdentifier;

        protected CommonTransactionInformationImpl(CommonTransactionInformationBuilder builder) {
            this.tradableOnTradingVenue = builder.getTradableOnTradingVenue();
            this.underlierTradedOnTradingVenue = builder.getUnderlierTradedOnTradingVenue();
            this.underlierAssetTradingPlatformIdentifier = builder.getUnderlierAssetTradingPlatformIdentifier();
            this.internalTradeIdentifier = builder.getInternalTradeIdentifier();
        }

        @Override
        @RosettaAttribute(value="tradableOnTradingVenue")
        @RuneAttribute(value="tradableOnTradingVenue")
        public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
            return this.tradableOnTradingVenue;
        }

        @Override
        @RosettaAttribute(value="underlierTradedOnTradingVenue")
        @RuneAttribute(value="underlierTradedOnTradingVenue")
        public Boolean getUnderlierTradedOnTradingVenue() {
            return this.underlierTradedOnTradingVenue;
        }

        @Override
        @RosettaAttribute(value="underlierAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlierAssetTradingPlatformIdentifier")
        public String getUnderlierAssetTradingPlatformIdentifier() {
            return this.underlierAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="internalTradeIdentifier")
        @RuneAttribute(value="internalTradeIdentifier")
        public String getInternalTradeIdentifier() {
            return this.internalTradeIdentifier;
        }

        @Override
        public CommonTransactionInformation build() {
            return this;
        }

        @Override
        public CommonTransactionInformationBuilder toBuilder() {
            CommonTransactionInformationBuilder builder = CommonTransactionInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonTransactionInformationBuilder builder) {
            Optional.ofNullable(this.getTradableOnTradingVenue()).ifPresent(builder::setTradableOnTradingVenue);
            Optional.ofNullable(this.getUnderlierTradedOnTradingVenue()).ifPresent(builder::setUnderlierTradedOnTradingVenue);
            Optional.ofNullable(this.getUnderlierAssetTradingPlatformIdentifier()).ifPresent(builder::setUnderlierAssetTradingPlatformIdentifier);
            Optional.ofNullable(this.getInternalTradeIdentifier()).ifPresent(builder::setInternalTradeIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommonTransactionInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.tradableOnTradingVenue, (Object)_that.getTradableOnTradingVenue())) {
                return false;
            }
            if (!Objects.equals(this.underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) {
                return false;
            }
            if (!Objects.equals(this.underlierAssetTradingPlatformIdentifier, _that.getUnderlierAssetTradingPlatformIdentifier())) {
                return false;
            }
            return Objects.equals(this.internalTradeIdentifier, _that.getInternalTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradableOnTradingVenue != null ? ((Object)((Object)this.tradableOnTradingVenue)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierTradedOnTradingVenue != null ? this.underlierTradedOnTradingVenue.hashCode() : 0);
            _result = 31 * _result + (this.underlierAssetTradingPlatformIdentifier != null ? this.underlierAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.internalTradeIdentifier != null ? this.internalTradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommonTransactionInformation {tradableOnTradingVenue=" + String.valueOf((Object)this.tradableOnTradingVenue) + ", underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue + ", underlierAssetTradingPlatformIdentifier=" + this.underlierAssetTradingPlatformIdentifier + ", internalTradeIdentifier=" + this.internalTradeIdentifier + "}";
        }
    }
}

