/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.meta.FCAPartyInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FCAPartyInformation", builder=FCAPartyInformationBuilderImpl.class, version="6.25.3")
@RuneDataType(value="FCAPartyInformation", model="drr", builder=FCAPartyInformationBuilderImpl.class, version="6.25.3")
public interface FCAPartyInformation
extends RosettaModelObject {
    public static final FCAPartyInformationMeta metaData = new FCAPartyInformationMeta();

    public NatureOfPartyEnum getNatureOfParty();

    public CorporateSector getCorporateSector();

    public Boolean getExceedsClearingThreshold();

    public Boolean getDirectlyLinkedActivity();

    public FCAPartyInformation build();

    public FCAPartyInformationBuilder toBuilder();

    public static FCAPartyInformationBuilder builder() {
        return new FCAPartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends FCAPartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FCAPartyInformation> getType() {
        return FCAPartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("natureOfParty"), NatureOfPartyEnum.class, (Object)this.getNatureOfParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("corporateSector"), processor, CorporateSector.class, this.getCorporateSector(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exceedsClearingThreshold"), Boolean.class, (Object)this.getExceedsClearingThreshold(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("directlyLinkedActivity"), Boolean.class, (Object)this.getDirectlyLinkedActivity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FCAPartyInformationBuilderImpl
    implements FCAPartyInformationBuilder {
        protected NatureOfPartyEnum natureOfParty;
        protected CorporateSector.CorporateSectorBuilder corporateSector;
        protected Boolean exceedsClearingThreshold;
        protected Boolean directlyLinkedActivity;

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public NatureOfPartyEnum getNatureOfParty() {
            return this.natureOfParty;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public CorporateSector.CorporateSectorBuilder getCorporateSector() {
            return this.corporateSector;
        }

        @Override
        public CorporateSector.CorporateSectorBuilder getOrCreateCorporateSector() {
            CorporateSector.CorporateSectorBuilder result = this.corporateSector != null ? this.corporateSector : (this.corporateSector = CorporateSector.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public Boolean getExceedsClearingThreshold() {
            return this.exceedsClearingThreshold;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedActivity")
        @RuneAttribute(value="directlyLinkedActivity")
        public Boolean getDirectlyLinkedActivity() {
            return this.directlyLinkedActivity;
        }

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public FCAPartyInformationBuilder setNatureOfParty(NatureOfPartyEnum _natureOfParty) {
            this.natureOfParty = _natureOfParty == null ? null : _natureOfParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public FCAPartyInformationBuilder setCorporateSector(CorporateSector _corporateSector) {
            this.corporateSector = _corporateSector == null ? null : _corporateSector.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public FCAPartyInformationBuilder setExceedsClearingThreshold(Boolean _exceedsClearingThreshold) {
            this.exceedsClearingThreshold = _exceedsClearingThreshold == null ? null : _exceedsClearingThreshold;
            return this;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedActivity")
        @RuneAttribute(value="directlyLinkedActivity")
        public FCAPartyInformationBuilder setDirectlyLinkedActivity(Boolean _directlyLinkedActivity) {
            this.directlyLinkedActivity = _directlyLinkedActivity == null ? null : _directlyLinkedActivity;
            return this;
        }

        @Override
        public FCAPartyInformation build() {
            return new FCAPartyInformationImpl(this);
        }

        @Override
        public FCAPartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public FCAPartyInformationBuilder prune() {
            if (this.corporateSector != null && !this.corporateSector.prune().hasData()) {
                this.corporateSector = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNatureOfParty() != null) {
                return true;
            }
            if (this.getCorporateSector() != null && this.getCorporateSector().hasData()) {
                return true;
            }
            if (this.getExceedsClearingThreshold() != null) {
                return true;
            }
            return this.getDirectlyLinkedActivity() != null;
        }

        public FCAPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FCAPartyInformationBuilder o = (FCAPartyInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorporateSector(), (RosettaModelObjectBuilder)o.getCorporateSector(), this::setCorporateSector);
            merger.mergeBasic((Object)this.getNatureOfParty(), (Object)o.getNatureOfParty(), this::setNatureOfParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExceedsClearingThreshold(), (Object)o.getExceedsClearingThreshold(), this::setExceedsClearingThreshold, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirectlyLinkedActivity(), (Object)o.getDirectlyLinkedActivity(), this::setDirectlyLinkedActivity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FCAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfParty, (Object)_that.getNatureOfParty())) {
                return false;
            }
            if (!Objects.equals(this.corporateSector, _that.getCorporateSector())) {
                return false;
            }
            if (!Objects.equals(this.exceedsClearingThreshold, _that.getExceedsClearingThreshold())) {
                return false;
            }
            return Objects.equals(this.directlyLinkedActivity, _that.getDirectlyLinkedActivity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.natureOfParty != null ? ((Object)((Object)this.natureOfParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateSector != null ? this.corporateSector.hashCode() : 0);
            _result = 31 * _result + (this.exceedsClearingThreshold != null ? this.exceedsClearingThreshold.hashCode() : 0);
            _result = 31 * _result + (this.directlyLinkedActivity != null ? this.directlyLinkedActivity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FCAPartyInformationBuilder {natureOfParty=" + String.valueOf((Object)this.natureOfParty) + ", corporateSector=" + String.valueOf(this.corporateSector) + ", exceedsClearingThreshold=" + this.exceedsClearingThreshold + ", directlyLinkedActivity=" + this.directlyLinkedActivity + "}";
        }
    }

    public static interface FCAPartyInformationBuilder
    extends FCAPartyInformation,
    RosettaModelObjectBuilder {
        public CorporateSector.CorporateSectorBuilder getOrCreateCorporateSector();

        @Override
        public CorporateSector.CorporateSectorBuilder getCorporateSector();

        public FCAPartyInformationBuilder setNatureOfParty(NatureOfPartyEnum var1);

        public FCAPartyInformationBuilder setCorporateSector(CorporateSector var1);

        public FCAPartyInformationBuilder setExceedsClearingThreshold(Boolean var1);

        public FCAPartyInformationBuilder setDirectlyLinkedActivity(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("natureOfParty"), NatureOfPartyEnum.class, (Object)this.getNatureOfParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("corporateSector"), processor, CorporateSector.CorporateSectorBuilder.class, this.getCorporateSector(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exceedsClearingThreshold"), Boolean.class, (Object)this.getExceedsClearingThreshold(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("directlyLinkedActivity"), Boolean.class, (Object)this.getDirectlyLinkedActivity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FCAPartyInformationBuilder prune();
    }

    public static class FCAPartyInformationImpl
    implements FCAPartyInformation {
        private final NatureOfPartyEnum natureOfParty;
        private final CorporateSector corporateSector;
        private final Boolean exceedsClearingThreshold;
        private final Boolean directlyLinkedActivity;

        protected FCAPartyInformationImpl(FCAPartyInformationBuilder builder) {
            this.natureOfParty = builder.getNatureOfParty();
            this.corporateSector = Optional.ofNullable(builder.getCorporateSector()).map(f -> f.build()).orElse(null);
            this.exceedsClearingThreshold = builder.getExceedsClearingThreshold();
            this.directlyLinkedActivity = builder.getDirectlyLinkedActivity();
        }

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public NatureOfPartyEnum getNatureOfParty() {
            return this.natureOfParty;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public CorporateSector getCorporateSector() {
            return this.corporateSector;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public Boolean getExceedsClearingThreshold() {
            return this.exceedsClearingThreshold;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedActivity")
        @RuneAttribute(value="directlyLinkedActivity")
        public Boolean getDirectlyLinkedActivity() {
            return this.directlyLinkedActivity;
        }

        @Override
        public FCAPartyInformation build() {
            return this;
        }

        @Override
        public FCAPartyInformationBuilder toBuilder() {
            FCAPartyInformationBuilder builder = FCAPartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FCAPartyInformationBuilder builder) {
            Optional.ofNullable(this.getNatureOfParty()).ifPresent(builder::setNatureOfParty);
            Optional.ofNullable(this.getCorporateSector()).ifPresent(builder::setCorporateSector);
            Optional.ofNullable(this.getExceedsClearingThreshold()).ifPresent(builder::setExceedsClearingThreshold);
            Optional.ofNullable(this.getDirectlyLinkedActivity()).ifPresent(builder::setDirectlyLinkedActivity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FCAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfParty, (Object)_that.getNatureOfParty())) {
                return false;
            }
            if (!Objects.equals(this.corporateSector, _that.getCorporateSector())) {
                return false;
            }
            if (!Objects.equals(this.exceedsClearingThreshold, _that.getExceedsClearingThreshold())) {
                return false;
            }
            return Objects.equals(this.directlyLinkedActivity, _that.getDirectlyLinkedActivity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.natureOfParty != null ? ((Object)((Object)this.natureOfParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateSector != null ? this.corporateSector.hashCode() : 0);
            _result = 31 * _result + (this.exceedsClearingThreshold != null ? this.exceedsClearingThreshold.hashCode() : 0);
            _result = 31 * _result + (this.directlyLinkedActivity != null ? this.directlyLinkedActivity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FCAPartyInformation {natureOfParty=" + String.valueOf((Object)this.natureOfParty) + ", corporateSector=" + String.valueOf(this.corporateSector) + ", exceedsClearingThreshold=" + this.exceedsClearingThreshold + ", directlyLinkedActivity=" + this.directlyLinkedActivity + "}";
        }
    }
}

