/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.meta.PartyInformationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyInformation", builder=PartyInformationBuilderImpl.class, version="6.25.3")
@RuneDataType(value="PartyInformation", model="drr", builder=PartyInformationBuilderImpl.class, version="6.25.3")
public interface PartyInformation
extends RosettaModelObject {
    public static final PartyInformationMeta metaData = new PartyInformationMeta();

    public ReferenceWithMetaParty getPartyReference();

    public List<? extends NaturalPersonRole> getRelatedPerson();

    public List<? extends RelatedParty> getRelatedParty();

    public List<? extends ReportingRegime> getRegimeInformation();

    public PartyInformation build();

    public PartyInformationBuilder toBuilder();

    public static PartyInformationBuilder builder() {
        return new PartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyInformation> getType() {
        return PartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedPerson"), processor, NaturalPersonRole.class, this.getRelatedPerson(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.class, this.getRegimeInformation(), new AttributeMeta[0]);
    }

    public static class PartyInformationBuilderImpl
    implements PartyInformationBuilder {
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
        protected List<NaturalPersonRole.NaturalPersonRoleBuilder> relatedPerson = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected List<ReportingRegime.ReportingRegimeBuilder> regimeInformation = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getRelatedPerson() {
            return this.relatedPerson;
        }

        @Override
        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreateRelatedPerson(int index) {
            if (this.relatedPerson == null) {
                this.relatedPerson = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
            }
            return (NaturalPersonRole.NaturalPersonRoleBuilder)this.getIndex(this.relatedPerson, index, () -> {
                NaturalPersonRole.NaturalPersonRoleBuilder newRelatedPerson = NaturalPersonRole.builder();
                return newRelatedPerson;
            });
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation() {
            return this.regimeInformation;
        }

        @Override
        public ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int index) {
            if (this.regimeInformation == null) {
                this.regimeInformation = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();
            }
            return (ReportingRegime.ReportingRegimeBuilder)this.getIndex(this.regimeInformation, index, () -> {
                ReportingRegime.ReportingRegimeBuilder newRegimeInformation = ReportingRegime.builder();
                return newRegimeInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyInformationBuilder setPartyReference(ReferenceWithMetaParty _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        public PartyInformationBuilder setPartyReferenceValue(Party _partyReference) {
            this.getOrCreatePartyReference().setValue(_partyReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public PartyInformationBuilder addRelatedPerson(NaturalPersonRole _relatedPerson) {
            if (_relatedPerson != null) {
                this.relatedPerson.add(_relatedPerson.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationBuilder addRelatedPerson(NaturalPersonRole _relatedPerson, int idx) {
            this.getIndex(this.relatedPerson, idx, () -> _relatedPerson.toBuilder());
            return this;
        }

        @Override
        public PartyInformationBuilder addRelatedPerson(List<? extends NaturalPersonRole> relatedPersons) {
            if (relatedPersons != null) {
                for (NaturalPersonRole naturalPersonRole : relatedPersons) {
                    this.relatedPerson.add(naturalPersonRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedPerson")
        public PartyInformationBuilder setRelatedPerson(List<? extends NaturalPersonRole> relatedPersons) {
            this.relatedPerson = relatedPersons == null ? new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>() : (List)relatedPersons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public PartyInformationBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public PartyInformationBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public PartyInformationBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public PartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation) {
            if (_regimeInformation != null) {
                this.regimeInformation.add(_regimeInformation.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation, int idx) {
            this.getIndex(this.regimeInformation, idx, () -> _regimeInformation.toBuilder());
            return this;
        }

        @Override
        public PartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
            if (regimeInformations != null) {
                for (ReportingRegime reportingRegime : regimeInformations) {
                    this.regimeInformation.add(reportingRegime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimeInformation")
        public PartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
            this.regimeInformation = regimeInformations == null ? new ArrayList<ReportingRegime.ReportingRegimeBuilder>() : (List)regimeInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyInformation build() {
            return new PartyInformationImpl(this);
        }

        @Override
        public PartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyInformationBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.relatedPerson = this.relatedPerson.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.regimeInformation = this.regimeInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getRelatedPerson() != null && this.getRelatedPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRegimeInformation() != null && this.getRegimeInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyInformationBuilder o = (PartyInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getRelatedPerson(), o.getRelatedPerson(), this::getOrCreateRelatedPerson);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta(this.getRegimeInformation(), o.getRegimeInformation(), this::getOrCreateRegimeInformation);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedPerson, _that.getRelatedPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return ListEquals.listEquals(this.regimeInformation, _that.getRegimeInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.relatedPerson != null ? this.relatedPerson.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.regimeInformation != null ? this.regimeInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyInformationBuilder {partyReference=" + String.valueOf(this.partyReference) + ", relatedPerson=" + String.valueOf(this.relatedPerson) + ", relatedParty=" + String.valueOf(this.relatedParty) + ", regimeInformation=" + String.valueOf(this.regimeInformation) + "}";
        }
    }

    public static interface PartyInformationBuilder
    extends PartyInformation,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();

        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreateRelatedPerson(int var1);

        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getRelatedPerson();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int var1);

        public List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation();

        public PartyInformationBuilder setPartyReference(ReferenceWithMetaParty var1);

        public PartyInformationBuilder setPartyReferenceValue(Party var1);

        public PartyInformationBuilder addRelatedPerson(NaturalPersonRole var1);

        public PartyInformationBuilder addRelatedPerson(NaturalPersonRole var1, int var2);

        public PartyInformationBuilder addRelatedPerson(List<? extends NaturalPersonRole> var1);

        public PartyInformationBuilder setRelatedPerson(List<? extends NaturalPersonRole> var1);

        public PartyInformationBuilder addRelatedParty(RelatedParty var1);

        public PartyInformationBuilder addRelatedParty(RelatedParty var1, int var2);

        public PartyInformationBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public PartyInformationBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public PartyInformationBuilder addRegimeInformation(ReportingRegime var1);

        public PartyInformationBuilder addRegimeInformation(ReportingRegime var1, int var2);

        public PartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> var1);

        public PartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedPerson"), processor, NaturalPersonRole.NaturalPersonRoleBuilder.class, this.getRelatedPerson(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.ReportingRegimeBuilder.class, this.getRegimeInformation(), new AttributeMeta[0]);
        }

        public PartyInformationBuilder prune();
    }

    public static class PartyInformationImpl
    implements PartyInformation {
        private final ReferenceWithMetaParty partyReference;
        private final List<? extends NaturalPersonRole> relatedPerson;
        private final List<? extends RelatedParty> relatedParty;
        private final List<? extends ReportingRegime> regimeInformation;

        protected PartyInformationImpl(PartyInformationBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.relatedPerson = Optional.ofNullable(builder.getRelatedPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.regimeInformation = Optional.ofNullable(builder.getRegimeInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public ReferenceWithMetaParty getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public List<? extends NaturalPersonRole> getRelatedPerson() {
            return this.relatedPerson;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public List<? extends ReportingRegime> getRegimeInformation() {
            return this.regimeInformation;
        }

        @Override
        public PartyInformation build() {
            return this;
        }

        @Override
        public PartyInformationBuilder toBuilder() {
            PartyInformationBuilder builder = PartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyInformationBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getRelatedPerson()).ifPresent(builder::setRelatedPerson);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getRegimeInformation()).ifPresent(builder::setRegimeInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedPerson, _that.getRelatedPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return ListEquals.listEquals(this.regimeInformation, _that.getRegimeInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.relatedPerson != null ? this.relatedPerson.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.regimeInformation != null ? this.regimeInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyInformation {partyReference=" + String.valueOf(this.partyReference) + ", relatedPerson=" + String.valueOf(this.relatedPerson) + ", relatedParty=" + String.valueOf(this.relatedParty) + ", regimeInformation=" + String.valueOf(this.regimeInformation) + "}";
        }
    }
}

