/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityFixedPriceQuantityDefault.class)
public abstract class CommodityFixedPriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceQuantity evaluate(TradeLot tradeLot) {
        PriceQuantity fixedLegPriceQuantity;
        PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantityBuilder = this.doEvaluate(tradeLot);
        if (fixedLegPriceQuantityBuilder == null) {
            fixedLegPriceQuantity = null;
        } else {
            fixedLegPriceQuantity = fixedLegPriceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)fixedLegPriceQuantity);
        }
        return fixedLegPriceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot var1);

    public static class CommodityFixedPriceQuantityDefault
    extends CommodityFixedPriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot) {
            PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity = PriceQuantity.builder();
            return this.assignOutput(fixedLegPriceQuantity, tradeLot);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity, TradeLot tradeLot) {
            MapperC thenArg = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
            fixedLegPriceQuantity = (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PriceQuantity)thenArg.get())).get());
            return Optional.ofNullable(fixedLegPriceQuantity).map(o -> o.prune()).orElse(null);
        }
    }
}

