/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.common.settlement.Cashflow;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FXLeg1Default.class)
public abstract class FXLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsFXForward isFXForward;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Cashflow evaluate(Product product) {
        Cashflow fxLeg1;
        Cashflow.CashflowBuilder fxLeg1Builder = this.doEvaluate(product);
        if (fxLeg1Builder == null) {
            fxLeg1 = null;
        } else {
            fxLeg1 = fxLeg1Builder.build();
            this.objectValidator.validate(Cashflow.class, (RosettaModelObject)fxLeg1);
        }
        return fxLeg1;
    }

    protected abstract Cashflow.CashflowBuilder doEvaluate(Product var1);

    public static class FXLeg1Default
    extends FXLeg1 {
        @Override
        protected Cashflow.CashflowBuilder doEvaluate(Product product) {
            Cashflow.CashflowBuilder fxLeg1 = Cashflow.builder();
            return this.assignOutput(fxLeg1, product);
        }

        protected Cashflow.CashflowBuilder assignOutput(Cashflow.CashflowBuilder fxLeg1, Product product) {
            fxLeg1 = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXForward.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXOption.evaluate(product)))).getOrDefault(Boolean.valueOf(false)) != false ? (Cashflow.CashflowBuilder)this.toBuilder((RosettaModelObject)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()), MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2())}).min(item -> item.map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).get()) : null;
            return Optional.ofNullable(fxLeg1).map(o -> o.prune()).orElse(null);
        }
    }
}

