/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCRPBullion;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;

@ImplementedBy(value=IsCommodityBullionDefault.class)
public abstract class IsCommodityBullion
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCRPBullion isCRPBullion;
    @Inject
    protected StringContains stringContains;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    protected abstract MapperS<? extends FieldWithMetaString> productIdentifier(Product var1);

    protected abstract MapperS<? extends FieldWithMetaString> productTaxonomy(Product var1);

    protected abstract MapperS<? extends FieldWithMetaString> productClass(Product var1);

    protected abstract MapperS<? extends FieldWithMetaString> commodityReferencePrice(Product var1);

    public static class IsCommodityBullionDefault
    extends IsCommodityBullion {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            if (ExpressionOperatorsNullSafe.exists(this.productClass(product)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.commodityReferencePrice(product))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)this.productClass(product).get();
                FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)this.commodityReferencePrice(product).get();
                result = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.stringContains.evaluate(fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue(), "Metals:Precious"))).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCRPBullion.evaluate(fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())))).get();
            } else {
                FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)this.productClass(product).get();
                if (ExpressionOperatorsNullSafe.exists(this.productClass(product)).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.stringContains.evaluate(fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue(), "Metals:Precious")))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    result = true;
                } else {
                    FieldWithMetaString fieldWithMetaString3 = (FieldWithMetaString)this.commodityReferencePrice(product).get();
                    result = ExpressionOperatorsNullSafe.exists(this.commodityReferencePrice(product)).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCRPBullion.evaluate(fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue())))).getOrDefault(Boolean.valueOf(false)) != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }
            return result;
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> productIdentifier(Product product) {
            MapperC thenArg0 = MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()).map("getMeta", a -> a.getMeta()).map("getScheme", a -> a.getScheme()), (Mapper)MapperS.of((Object)"http://www.fpml.org/coding-scheme/product-taxonomy"), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg2 = MapperS.of((Object)((ReferenceWithMetaProductIdentifier)thenArg1.get()));
            return thenArg2.mapSingleToItem(item -> item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> productTaxonomy(Product product) {
            MapperC thenArg0 = MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSource", _productTaxonomy -> _productTaxonomy.getSource()), (Mapper)MapperS.of((Object)TaxonomySourceEnum.ISDA), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg2 = MapperS.of((Object)((ProductTaxonomy)thenArg1.get()));
            return thenArg2.mapSingleToItem(item -> item.map("getValue", _productTaxonomy -> _productTaxonomy.getValue()).map("getName", taxonomyValue -> taxonomyValue.getName()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> productClass(Product product) {
            if (ExpressionOperatorsNullSafe.exists(this.productTaxonomy(product)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.productIdentifier(product))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((FieldWithMetaString)ExpressionOperatorsNullSafe.distinct((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{this.productTaxonomy(product), this.productIdentifier(product)})).get()));
            }
            if (ExpressionOperatorsNullSafe.exists(this.productTaxonomy(product)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.productTaxonomy(product);
            }
            if (ExpressionOperatorsNullSafe.exists(this.productIdentifier(product)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.productIdentifier(product);
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> commodityReferencePrice(Product product) {
            MapperC thenArg0 = MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", _productIdentifier -> _productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISDACRP), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg2 = MapperS.of((Object)((ReferenceWithMetaProductIdentifier)thenArg1.get()));
            MapperC thenArg3 = MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", _referenceWithMetaCommodity -> _referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
            MapperC thenArg4 = thenArg3.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", _productIdentifier -> _productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISDACRP), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg5 = MapperS.of((Object)((ReferenceWithMetaProductIdentifier)thenArg4.get()));
            return MapperS.of((Object)((FieldWithMetaString)MapperC.of((MapperBuilder[])new MapperBuilder[]{thenArg2.mapSingleToItem(item -> item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier())), thenArg5.mapSingleToItem(item -> item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()))}).get()));
        }
    }
}

