/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;

@ImplementedBy(value=IsFixedInterestRateDefault.class)
public abstract class IsFixedInterestRate
implements RosettaFunction {
    public Boolean evaluate(PriceSchedule price) {
        Boolean result = this.doEvaluate(price);
        return result;
    }

    protected abstract Boolean doEvaluate(PriceSchedule var1);

    public static class IsFixedInterestRateDefault
    extends IsFixedInterestRate {
        @Override
        protected Boolean doEvaluate(PriceSchedule price) {
            Boolean result = null;
            return this.assignOutput(result, price);
        }

        protected Boolean assignOutput(Boolean result, PriceSchedule price) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)price).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get();
            return result;
        }
    }
}

