/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=RateOptionDefault.class)
public abstract class RateOption
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public FloatingRateOption evaluate(InterestRatePayout interestRatePayout) {
        FloatingRateOption rateOption;
        FloatingRateOption.FloatingRateOptionBuilder rateOptionBuilder = this.doEvaluate(interestRatePayout);
        if (rateOptionBuilder == null) {
            rateOption = null;
        } else {
            rateOption = rateOptionBuilder.build();
            this.objectValidator.validate(FloatingRateOption.class, (RosettaModelObject)rateOption);
        }
        return rateOption;
    }

    protected abstract FloatingRateOption.FloatingRateOptionBuilder doEvaluate(InterestRatePayout var1);

    public static class RateOptionDefault
    extends RateOption {
        @Override
        protected FloatingRateOption.FloatingRateOptionBuilder doEvaluate(InterestRatePayout interestRatePayout) {
            FloatingRateOption.FloatingRateOptionBuilder rateOption = FloatingRateOption.builder();
            return this.assignOutput(rateOption, interestRatePayout);
        }

        protected FloatingRateOption.FloatingRateOptionBuilder assignOutput(FloatingRateOption.FloatingRateOptionBuilder rateOption, InterestRatePayout interestRatePayout) {
            ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption1;
            ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption0;
            rateOption = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaFloatingRateOption0 = (ReferenceWithMetaFloatingRateOption)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).get()) == null ? null : (FloatingRateOption.FloatingRateOptionBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaFloatingRateOption0.getValue())) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaFloatingRateOption1 = (ReferenceWithMetaFloatingRateOption)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).get()) == null ? null : (FloatingRateOption.FloatingRateOptionBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaFloatingRateOption1.getValue())) : null);
            return Optional.ofNullable(rateOption).map(o -> o.prune()).orElse(null);
        }
    }
}

