/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=TradableProductForEventDefault.class)
public abstract class TradableProductForEvent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected TradeForEvent tradeForEvent;

    public TradableProduct evaluate(ReportableEvent reportableEvent) {
        TradableProduct tradableProduct;
        TradableProduct.TradableProductBuilder tradableProductBuilder = this.doEvaluate(reportableEvent);
        if (tradableProductBuilder == null) {
            tradableProduct = null;
        } else {
            tradableProduct = tradableProductBuilder.build();
            this.objectValidator.validate(TradableProduct.class, (RosettaModelObject)tradableProduct);
        }
        return tradableProduct;
    }

    protected abstract TradableProduct.TradableProductBuilder doEvaluate(ReportableEvent var1);

    public static class TradableProductForEventDefault
    extends TradableProductForEvent {
        @Override
        protected TradableProduct.TradableProductBuilder doEvaluate(ReportableEvent reportableEvent) {
            TradableProduct.TradableProductBuilder tradableProduct = TradableProduct.builder();
            return this.assignOutput(tradableProduct, reportableEvent);
        }

        protected TradableProduct.TradableProductBuilder assignOutput(TradableProduct.TradableProductBuilder tradableProduct, ReportableEvent reportableEvent) {
            tradableProduct = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent)).map("getTradableProduct", trade -> trade.getTradableProduct()).get()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.positionForEvent.evaluate(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.positionForEvent.evaluate(reportableEvent)).map("getPositionBase", counterpartyPosition -> counterpartyPosition.getPositionBase()).get()) : null);
            return Optional.ofNullable(tradableProduct).map(o -> o.prune()).orElse(null);
        }
    }
}

