/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.basket.reports.CustomBasketCodeRule;
import javax.inject.Inject;

@ImplementedBy(value=CustomBasketIndicatorRuleDefault.class)
public abstract class CustomBasketIndicatorRule
implements ReportFunction<TransactionReportInstruction, Boolean> {
    @Inject
    protected CustomBasketCodeRule customBasketCodeRule;

    public Boolean evaluate(TransactionReportInstruction input) {
        Boolean output = this.doEvaluate(input);
        return output;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    public static class CustomBasketIndicatorRuleDefault
    extends CustomBasketIndicatorRule {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction input) {
            Boolean output = null;
            return this.assignOutput(output, input);
        }

        protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
            output = (Boolean)MapperS.of((Object)input).mapSingleToItem(item -> {
                String string = this.customBasketCodeRule.evaluate((ReportableEvent)item.get());
                return string == null ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.ofNull()).asMapper() : ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build())).asMapper();
            }).get();
            return output;
        }
    }
}

