/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.contract.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import java.util.Arrays;
import javax.inject.Inject;

@ImplementedBy(value=EmbeddedOptionTypeRuleDefault.class)
public abstract class EmbeddedOptionTypeRule
implements ReportFunction<TransactionReportInstruction, EmbeddedOptionTypeEnum> {
    @Inject
    protected TradeForEvent tradeForEvent;

    public EmbeddedOptionTypeEnum evaluate(TransactionReportInstruction input) {
        EmbeddedOptionTypeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract EmbeddedOptionTypeEnum doEvaluate(TransactionReportInstruction var1);

    public static class EmbeddedOptionTypeRuleDefault
    extends EmbeddedOptionTypeRule {
        @Override
        protected EmbeddedOptionTypeEnum doEvaluate(TransactionReportInstruction input) {
            EmbeddedOptionTypeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected EmbeddedOptionTypeEnum assignOutput(EmbeddedOptionTypeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()));
            output = (EmbeddedOptionTypeEnum)((Object)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()), Arrays.asList("cancelableProvision", "earlyTerminationProvision", "evergreenProvision", "extendibleProvision"), Arrays.asList("extendibleProvision")).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)EmbeddedOptionTypeEnum.EXTD));
                }
                if (ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()), Arrays.asList("cancelableProvision", "earlyTerminationProvision", "evergreenProvision", "extendibleProvision"), Arrays.asList("cancelableProvision")).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)EmbeddedOptionTypeEnum.CANC));
                }
                if (ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()), Arrays.asList("cancelableProvision", "earlyTerminationProvision", "evergreenProvision", "extendibleProvision"), Arrays.asList("earlyTerminationProvision")).andNullSafe(ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getEarlyTerminationProvision", terminationProvision -> terminationProvision.getEarlyTerminationProvision()), Arrays.asList("mandatoryEarlyTermination", "mandatoryEarlyTerminationDateTenor", "optionalEarlyTermination", "optionalEarlyTerminationParameters"), Arrays.asList("optionalEarlyTermination"))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)EmbeddedOptionTypeEnum.OPET));
                }
                if (ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()), Arrays.asList("cancelableProvision", "earlyTerminationProvision", "evergreenProvision", "extendibleProvision"), Arrays.asList("earlyTerminationProvision")).andNullSafe(ExpressionOperatorsNullSafe.onlyExists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getEarlyTerminationProvision", terminationProvision -> terminationProvision.getEarlyTerminationProvision()), Arrays.asList("mandatoryEarlyTermination", "mandatoryEarlyTerminationDateTenor", "optionalEarlyTermination", "optionalEarlyTerminationParameters"), Arrays.asList("mandatoryEarlyTermination"))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)EmbeddedOptionTypeEnum.MDET));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getExtendibleProvision", terminationProvision -> terminationProvision.getExtendibleProvision())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getCancelableProvision", terminationProvision -> terminationProvision.getCancelableProvision()))).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getTerminationProvision", economicTerms -> economicTerms.getTerminationProvision()).map("getEarlyTerminationProvision", terminationProvision -> terminationProvision.getEarlyTerminationProvision()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)EmbeddedOptionTypeEnum.OTHR));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

