/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetContractType;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumAmountRuleDefault.class)
public abstract class OptionPremiumAmountRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected GetContractType getContractType;
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.OptionPremiumAmountRule optionPremiumAmountRule;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class OptionPremiumAmountRuleDefault
    extends OptionPremiumAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            output = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.getContractType.evaluate(input))), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.optionPremiumAmountRule.evaluate(input)))).getOrDefault(Boolean.valueOf(false)) != false ? BigDecimal.valueOf(0L) : this.optionPremiumAmountRule.evaluate(input);
            return output;
        }
    }
}

