/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.HKMAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="HKMAPartyInformationFinancialNonFinancial")
@ImplementedBy(value=Default.class)
public interface HKMAPartyInformationFinancialNonFinancial
extends Validator<HKMAPartyInformation> {
    public static final String NAME = "HKMAPartyInformationFinancialNonFinancial";
    public static final String DEFINITION = "if natureOfParty = NatureOfPartyEnum -> Financial then corporateSector -> financialSector exists else if natureOfParty = NatureOfPartyEnum -> NonFinancial then corporateSector -> nonFinancialSector exists";

    public static class NoOp
    implements HKMAPartyInformationFinancialNonFinancial {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAPartyInformation hKMAPartyInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMAPartyInformationFinancialNonFinancial {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAPartyInformation hKMAPartyInformation) {
            ComparisonResult result = this.executeDataRule(hKMAPartyInformation);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMAPartyInformationFinancialNonFinancial.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAPartyInformation", (RosettaPath)path, (String)HKMAPartyInformationFinancialNonFinancial.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMAPartyInformationFinancialNonFinancial.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAPartyInformation", (RosettaPath)path, (String)HKMAPartyInformationFinancialNonFinancial.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMAPartyInformation hKMAPartyInformation) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)hKMAPartyInformation).map("getNatureOfParty", _hKMAPartyInformation -> _hKMAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)hKMAPartyInformation).map("getCorporateSector", _hKMAPartyInformation -> _hKMAPartyInformation.getCorporateSector()).mapC("getFinancialSector", corporateSector -> corporateSector.getFinancialSector()));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)hKMAPartyInformation).map("getNatureOfParty", _hKMAPartyInformation -> _hKMAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.NON_FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)hKMAPartyInformation).map("getCorporateSector", _hKMAPartyInformation -> _hKMAPartyInformation.getCorporateSector()).mapC("getNonFinancialSector", corporateSector -> corporateSector.getNonFinancialSector()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

