/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.functions;

import cdm.base.staticdata.party.EntityIdentifierTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierLEIForCreditCSADefault.class)
public abstract class GetUnderlierLEIForCreditCSA
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(Product product) {
        List<String> lei = this.doEvaluate(product);
        return lei;
    }

    protected abstract List<String> doEvaluate(Product var1);

    public static class GetUnderlierLEIForCreditCSADefault
    extends GetUnderlierLEIForCreditCSA {
        @Override
        protected List<String> doEvaluate(Product product) {
            ArrayList<String> lei = new ArrayList<String>();
            return this.assignOutput(lei, product);
        }

        protected List<String> assignOutput(List<String> lei, Product product) {
            MapperS thenArg = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()) : MapperS.ofNull());
            lei.addAll(thenArg.mapSingleToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg0 = item.mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier());
                    MapperC thenArg1 = thenArg0.filterItemNullSafe(_item -> ExpressionOperatorsNullSafe.areEqual((Mapper)_item.map("getIdentifierType", entityIdentifier -> entityIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)EntityIdentifierTypeEnum.LEI), (CardinalityOperator)CardinalityOperator.All).get());
                    return thenArg1.mapItem(_item -> _item.map("getIdentifier", entityIdentifier -> entityIdentifier.getIdentifier()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.mapC("getEntityId", legalEntity -> legalEntity.getEntityId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
                }
                return MapperC.ofNull();
            }).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            return lei;
        }
    }
}

