/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.CalculationPeriodToDaysCommodities;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityBasisLeg1Default.class)
public abstract class CommodityBasisLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodToDaysCommodities calculationPeriodToDaysCommodities;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout commodityLeg1;
        CommodityPayout.CommodityPayoutBuilder commodityLeg1Builder = this.doEvaluate(product);
        if (commodityLeg1Builder == null) {
            commodityLeg1 = null;
        } else {
            commodityLeg1 = commodityLeg1Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityLeg1);
        }
        return commodityLeg1;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayouts(Product var1);

    public static class CommodityBasisLeg1Default
    extends CommodityBasisLeg1 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder commodityLeg1 = CommodityPayout.builder();
            return this.assignOutput(commodityLeg1, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityLeg1, Product product) {
            Boolean _boolean = this.isCommoditySwapFloatFloat.evaluate(product);
            commodityLeg1 = _boolean != null && _boolean.booleanValue() ? (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.commodityPayouts(product).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityPayouts(product).min(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
                return fieldWithMetaString == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString.getValue());
            }).get()) : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.commodityPayouts(product).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityPayouts(product).min(item -> MapperS.of((Object)this.calculationPeriodToDaysCommodities.evaluate((CommodityPayout)item.get()))).get()) : null)) : null;
            return Optional.ofNullable(commodityLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }
    }
}

