/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2ReturnSwapDefault.class)
public abstract class InterestRateLeg2ReturnSwap
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRateLegs(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product var1);

    protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product var1);

    protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> flotingRateIndexSecurity(Product var1);

    protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexContractualProduct(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> IRPayoutContractualProduct(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> IRPayoutSecurity(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> fixedRateLegContractualProduct(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> floatingRateLegContractualProduct(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> fixedRateLegSecurity(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> floatingRateLegSecurity(Product var1);

    protected abstract MapperC<String> comparison(Product var1);

    protected abstract MapperS<String> sortedReturnSwapIdentifier(Product var1);

    public static class InterestRateLeg2ReturnSwapDefault
    extends InterestRateLeg2ReturnSwap {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum1;
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum0;
            interestRateLeg2 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.floatingRateLegs(product).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.exists(this.IRPayoutContractualProduct(product)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.fixedRateLegContractualProduct(product).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.fixedRateLegContractualProduct(product).get()) : (ExpressionOperatorsNullSafe.exists(this.floatingRateLegContractualProduct(product)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.areEqual((Mapper)((fieldWithMetaFloatingRateIndexEnum0 = (FieldWithMetaFloatingRateIndexEnum)this.floatingRateIndexContractualProduct(product).get()) == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum0.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), this.sortedReturnSwapIdentifier(product), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.floatingRateLegContractualProduct(product).get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.floatingRateLegs(product).get())) : (ExpressionOperatorsNullSafe.exists(this.IRPayoutSecurity(product)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.fixedRateLegSecurity(product).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.fixedRateLegSecurity(product).get()) : (ExpressionOperatorsNullSafe.exists(this.floatingRateLegSecurity(product)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.areEqual((Mapper)((fieldWithMetaFloatingRateIndexEnum1 = (FieldWithMetaFloatingRateIndexEnum)this.flotingRateIndexSecurity(product).get()) == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum1.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), this.sortedReturnSwapIdentifier(product), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.floatingRateLegSecurity(product).get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.floatingRateLegs(product).get())) : null)) : null))) : null) : null;
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRateLegs(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
            return this.interestRateLegs(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
            return this.interestRateLegs(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
        }

        @Override
        protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
        }

        @Override
        protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> flotingRateIndexSecurity(Product product) {
            return this.IRPayoutSecurity(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
        }

        @Override
        protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexContractualProduct(Product product) {
            return this.IRPayoutContractualProduct(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> IRPayoutContractualProduct(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> IRPayoutSecurity(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).map("getEconomicTerms", security -> security.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> fixedRateLegContractualProduct(Product product) {
            return this.IRPayoutContractualProduct(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> floatingRateLegContractualProduct(Product product) {
            return this.IRPayoutContractualProduct(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> fixedRateLegSecurity(Product product) {
            return this.IRPayoutSecurity(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> floatingRateLegSecurity(Product product) {
            return this.IRPayoutSecurity(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
        }

        @Override
        protected MapperC<String> comparison(Product product) {
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum0 = (FieldWithMetaFloatingRateIndexEnum)this.floatingRateIndexes(product).get();
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum1 = (FieldWithMetaFloatingRateIndexEnum)this.flotingRateIndexSecurity(product).get();
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum2 = (FieldWithMetaFloatingRateIndexEnum)this.floatingRateIndexContractualProduct(product).get();
            return MapperC.of((MapperBuilder[])new MapperBuilder[]{(fieldWithMetaFloatingRateIndexEnum0 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum0.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), (fieldWithMetaFloatingRateIndexEnum1 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum1.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), (fieldWithMetaFloatingRateIndexEnum2 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum2.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString)});
        }

        @Override
        protected MapperS<String> sortedReturnSwapIdentifier(Product product) {
            return this.comparison(product).max();
        }
    }
}

