/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.csa.rewrite.trade.functions.CSAInterestRateLeg2;
import drr.regulation.csa.rewrite.trade.functions.CommodityLeg2;
import drr.regulation.csa.rewrite.trade.functions.PayoutMatches;
import javax.inject.Inject;

@ImplementedBy(value=IsCSALeg2AlignedDefault.class)
public abstract class IsCSALeg2Aligned
implements RosettaFunction {
    @Inject
    protected CSAInterestRateLeg2 cSAInterestRateLeg2;
    @Inject
    protected drr.regulation.common.functions.CommodityLeg2 commodityLeg20;
    @Inject
    protected CommodityLeg2 commodityLeg21;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected PayoutMatches payoutMatches;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Boolean evaluate(TransactionReportInstruction transactionReportInstruction) {
        Boolean result = this.doEvaluate(transactionReportInstruction);
        return result;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<? extends Product> product(TransactionReportInstruction var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction var1);

    protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg2(TransactionReportInstruction var1);

    protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg2(TransactionReportInstruction var1);

    protected abstract MapperS<? extends CommodityPayout> csaCommodityLeg2(TransactionReportInstruction var1);

    protected abstract MapperS<? extends CommodityPayout> drrCommodityLeg2(TransactionReportInstruction var1);

    public static class IsCSALeg2AlignedDefault
    extends IsCSALeg2Aligned {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            Boolean result = null;
            return this.assignOutput(result, transactionReportInstruction);
        }

        protected Boolean assignOutput(Boolean result, TransactionReportInstruction transactionReportInstruction) {
            Boolean boolean1;
            Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate((EconomicTerms)this.economicTerms(transactionReportInstruction).get());
            result = boolean0 != null && boolean0 != false ? this.payoutMatches.evaluate((PayoutBase)this.csaInterestRateLeg2(transactionReportInstruction).get(), (PayoutBase)this.drrInterestRateLeg2(transactionReportInstruction).get()) : ((boolean1 = this.qualify_AssetClass_Commodity.evaluate((EconomicTerms)this.economicTerms(transactionReportInstruction).get())) != null && boolean1 != false ? this.payoutMatches.evaluate((PayoutBase)this.csaCommodityLeg2(transactionReportInstruction).get(), (PayoutBase)this.drrCommodityLeg2(transactionReportInstruction).get()) : Boolean.valueOf(true));
            return result;
        }

        @Override
        protected MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.productForTrade.evaluate(this.tradeForEvent.evaluate(transactionReportInstruction)));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(transactionReportInstruction).get()));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> csaInterestRateLeg2(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.cSAInterestRateLeg2.evaluate((Product)this.product(transactionReportInstruction).get()));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> drrInterestRateLeg2(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.interestRateLeg2.evaluate((Product)this.product(transactionReportInstruction).get()));
        }

        @Override
        protected MapperS<? extends CommodityPayout> csaCommodityLeg2(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.commodityLeg21.evaluate((Product)this.product(transactionReportInstruction).get()));
        }

        @Override
        protected MapperS<? extends CommodityPayout> drrCommodityLeg2(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.commodityLeg20.evaluate((Product)this.product(transactionReportInstruction).get()));
        }
    }
}

