/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.time.ZonedDateTime;
import javax.inject.Inject;

@ImplementedBy(value=EventTimestampRuleDefault.class)
public abstract class EventTimestampRule
implements ReportFunction<TransactionReportInstruction, ZonedDateTime> {
    @Inject
    protected drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule eventTimestampRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;

    public ZonedDateTime evaluate(TransactionReportInstruction input) {
        ZonedDateTime output = this.doEvaluate(input);
        return output;
    }

    protected abstract ZonedDateTime doEvaluate(TransactionReportInstruction var1);

    public static class EventTimestampRuleDefault
    extends EventTimestampRule {
        @Override
        protected ZonedDateTime doEvaluate(TransactionReportInstruction input) {
            ZonedDateTime output = null;
            return this.assignOutput(output, input);
        }

        protected ZonedDateTime assignOutput(ZonedDateTime output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            output = (ZonedDateTime)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.eventTimestampRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

