/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.PaymentType4Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportDTCC_CSA_VR_0053_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportDTCC_CSA_VR_0053_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportDTCC_CSA_VR_0053_01";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Credit or dtccAdditionalFields -> primaryAssetClass = Credit) then (if leg1 -> fixedRate is absent and leg1 exists and otherPayment -> paymentType any <> UFRO and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) then leg1 -> spread exists else leg1 -> spread is absent) else if (nonReportable -> postUpiData -> Header -> AssetClass = Rates or dtccAdditionalFields -> primaryAssetClass = InterestRate) then (if leg1 -> fixedRate is absent and leg1 exists and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) and leg2 -> spread is absent then leg1 -> spread exists else leg1 -> spread is absent) else if (nonReportable -> postUpiData -> Header -> AssetClass = Equity or dtccAdditionalFields -> primaryAssetClass = Equity) then (if price is absent and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) then leg1 -> spread exists else leg1 -> spread is absent)";

    public static class NoOp
    implements CSATransactionReportDTCC_CSA_VR_0053_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportDTCC_CSA_VR_0053_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportDTCC_CSA_VR_0053_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0053_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportDTCC_CSA_VR_0053_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0053_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.CREDIT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.CREDIT), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()))).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).mapC("getOtherPayment", _cSATransactionReport -> _cSATransactionReport.getOtherPayment()).map("getPaymentType", otherPayment -> otherPayment.getPaymentType()), (Mapper)MapperS.of((Object)((Object)PaymentType4Code.UFRO)), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                    }
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.RATES)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                    }
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getPrice", _cSATransactionReport -> _cSATransactionReport.getPrice())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                    }
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

