/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FXFarLeg;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import drr.standards.iosco.cde.base.price.functions.FormatToBaseOne18Rate;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ForwardExchangeRateRuleDefault.class)
public abstract class ForwardExchangeRateRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;
    @Inject
    protected FXFarLeg fXFarLeg;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
    @Inject
    protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
    @Inject
    protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
    @Inject
    protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;
    @Inject
    protected TradeForEvent tradeForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ForwardExchangeRateRuleDefault
    extends ForwardExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(reportableEvent -> {
                MapperS _thenArg0 = thenArg0.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Spot_Forward.evaluate((EconomicTerms)MapperS.of((Object)this.productForTrade.evaluate(this.tradeForEvent.evaluate((ReportableEvent)item.get()))).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDF.evaluate((EconomicTerms)MapperS.of((Object)this.productForTrade.evaluate(this.tradeForEvent.evaluate((ReportableEvent)item.get()))).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXOption.evaluate(this.productForTrade.evaluate(this.tradeForEvent.evaluate((ReportableEvent)item.get())))))).get());
                MapperS _thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)reportableEvent.get())));
                MapperS thenArg2 = _thenArg1.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Swap.evaluate((EconomicTerms)MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDS.evaluate((EconomicTerms)MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).get());
                MapperC thenArg3 = thenArg2.mapSingleToList(trade -> trade.map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)this.fXFarLeg.evaluate(this.productForTrade.evaluate((Trade)trade.get()))).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)this.fXFarLeg.evaluate(this.productForTrade.evaluate((Trade)trade.get()))).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (CardinalityOperator)CardinalityOperator.Any)).get()));
                MapperListOfLists thenArg4 = thenArg3.mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
                MapperC thenArg5 = thenArg4.flattenList();
                MapperC thenArg6 = MapperC.of((MapperBuilder[])new MapperBuilder[]{_thenArg0.mapSingleToItem(item -> {
                    MapperC thenArg = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate((ReportableEvent)item.get())), MapperC.of(this.contract_StrikePrice.evaluate((ReportableEvent)item.get()))}).filterItemNullSafe(_item -> ExpressionOperatorsNullSafe.areEqual((Mapper)_item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)_item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
                    return thenArg.last();
                }), thenArg5.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue())}).mapItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
                return thenArg6.last();
            });
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg1.get())).get();
            return output;
        }
    }
}

