/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.lei.LeiCategoryEnum;
import drr.enrichment.lei.functions.GetOrFetchLeiData;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_1003_05")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_1003_05
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_1003_05";
    public static final String DEFINITION = "if entityResponsibleForReporting exists then (GetOrFetchLeiData( nonReportable -> enrichment -> leiData, entityResponsibleForReporting ) -> entityStatus exists and GetOrFetchLeiData( nonReportable -> enrichment -> leiData, entityResponsibleForReporting ) -> entityCategory <> LeiCategoryEnum -> Branch)";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_1003_05 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_1003_05 {
        @Inject
        protected GetOrFetchLeiData getOrFetchLeiData;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_1003_05.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1003_05.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_1003_05.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1003_05.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEntityResponsibleForReporting", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEntityResponsibleForReporting())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getOrFetchLeiData.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEntityResponsibleForReporting", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEntityResponsibleForReporting()).get())).map("getEntityStatus", leiData -> leiData.getEntityStatus())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)this.getOrFetchLeiData.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEntityResponsibleForReporting", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEntityResponsibleForReporting()).get())).map("getEntityCategory", leiData -> leiData.getEntityCategory()), (Mapper)MapperS.of((Object)((Object)LeiCategoryEnum.BRANCH)), (CardinalityOperator)CardinalityOperator.Any));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

