/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.fca.ukemir.refit.trade.reports.PriceNotationRule;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.version3.price.functions.GetReportablePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=ContractPriceScheduleRuleDefault.class)
public abstract class ContractPriceScheduleRule
implements ReportFunction<TransactionReportInstruction, List<? extends PricePeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContinuousPriceSchedule create_ContinuousPriceSchedule;
    @Inject
    protected GetExpirationDate getExpirationDate;
    @Inject
    protected GetReportablePricePeriod getReportablePricePeriod;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected PriceNotationRule priceNotationRule;

    public List<? extends PricePeriod> evaluate(TransactionReportInstruction input) {
        List output;
        List<PricePeriod.PricePeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, output);
        }
        return output;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class ContractPriceScheduleRuleDefault
    extends ContractPriceScheduleRule {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<PricePeriod.PricePeriodBuilder> output = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = this.toBuilder(thenArg.mapSingleToList(item -> MapperC.of(this.create_ContinuousPriceSchedule.evaluate(this.getReportablePricePeriod.evaluate((ReportableEvent)item.get(), this.priceNotationRule.evaluate((TransactionReportInstruction)item.get())), this.getExpirationDate.evaluate((TransactionReportInstruction)item.get())))).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

