/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyLeg2Rule;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrency2RuleDefault.class)
public abstract class NotionalCurrency2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrency2RuleDefault
    extends NotionalCurrency2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.notionalCurrencyLeg2Rule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

