/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="JFSATransactionReportDTCC_JFSA_BR_0002a_01")
@ImplementedBy(value=Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0002a_01
extends Validator<JFSATransactionReport> {
    public static final String NAME = "JFSATransactionReportDTCC_JFSA_BR_0002a_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and [CommonContractType -> OPTN, CommonContractType -> SWPT, CommonContractType -> SWAP, CommonContractType -> CFDS] any = contractType and assetClass <> CommonAssetClass -> CURR then (if barrier -> _single -> price -> monetary exists then barrier -> _single -> currency exists)";

    public static class NoOp
    implements JFSATransactionReportDTCC_JFSA_BR_0002a_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements JFSATransactionReportDTCC_JFSA_BR_0002a_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            ComparisonResult result = this.executeDataRule(jFSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)JFSATransactionReportDTCC_JFSA_BR_0002a_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0002a_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)JFSATransactionReportDTCC_JFSA_BR_0002a_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0002a_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonContractType.OPTN)), MapperS.of((Object)((Object)CommonContractType.SWPT)), MapperS.of((Object)((Object)CommonContractType.SWAP)), MapperS.of((Object)((Object)CommonContractType.CFDS))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getContractType", _jFSATransactionReport -> _jFSATransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)jFSATransactionReport).map("getBarrier", _jFSATransactionReport -> _jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getPrice", barrierPrice -> barrierPrice.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)jFSATransactionReport).map("getBarrier", _jFSATransactionReport -> _jFSATransactionReport.getBarrier()).map("get_single", singleOrUpperAndLowerBarrier -> singleOrUpperAndLowerBarrier.get_single()).map("getCurrency", barrierPrice -> barrierPrice.getCurrency()));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

