/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="JFSATransactionReportDTCC_JFSA_BR_0099_01")
@ImplementedBy(value=Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0099_01
extends Validator<JFSATransactionReport> {
    public static final String NAME = "JFSATransactionReportDTCC_JFSA_BR_0099_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and [CommonAssetClass -> EQUI, CommonAssetClass -> COMM] any = assetClass then (if leg1 -> notionalQuantitySchedule -> value count <> leg1 -> notionalQuantitySchedule -> effectiveDate count then False)";

    public static class NoOp
    implements JFSATransactionReportDTCC_JFSA_BR_0099_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements JFSATransactionReportDTCC_JFSA_BR_0099_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            ComparisonResult result = this.executeDataRule(jFSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)JFSATransactionReportDTCC_JFSA_BR_0099_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0099_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)JFSATransactionReportDTCC_JFSA_BR_0099_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0099_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.COMM))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)jFSATransactionReport).map("getLeg1", _jFSATransactionReport -> _jFSATransactionReport.getLeg1()).mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).map("getValue", notionalPeriod -> notionalPeriod.getValue()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)jFSATransactionReport).map("getLeg1", _jFSATransactionReport -> _jFSATransactionReport.getLeg1()).mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)false));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

