/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.standards.iosco.cde.base.payment.PeriodicPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import drr.standards.iosco.cde.version1.meta.LegV1Meta;
import drr.standards.iso.Direction2Enum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegV1", builder=LegV1BuilderImpl.class, version="6.25.3")
@RuneDataType(value="LegV1", model="drr", builder=LegV1BuilderImpl.class, version="6.25.3")
public interface LegV1
extends RosettaModelObject {
    public static final LegV1Meta metaData = new LegV1Meta();

    public PeriodicPayment getPeriodicPayment();

    public BigDecimal getNotionalAmount();

    public List<? extends NotionalPeriod> getNotionalAmountSchedule();

    public List<? extends NotionalPeriod> getNotionalQuantitySchedule();

    public ISOCurrencyCodeEnum getNotionalCurrency();

    public BigDecimal getTotalNotionalQuantity();

    public BigDecimal getFixedRate();

    public ISOCurrencyCodeEnum getSettlementCurrency();

    public PriceFormat getSpread();

    public PriceNotationEnum getSpreadNotation();

    public ISOCurrencyCodeEnum getSpreadCurrency();

    public String getQuantityUnitOfMeasure();

    public Direction2Enum getDirection2();

    public LegV1 build();

    public LegV1Builder toBuilder();

    public static LegV1Builder builder() {
        return new LegV1BuilderImpl();
    }

    default public RosettaMetaData<? extends LegV1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegV1> getType() {
        return LegV1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.class, this.getSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LegV1BuilderImpl
    implements LegV1Builder {
        protected PeriodicPayment.PeriodicPaymentBuilder periodicPayment;
        protected BigDecimal notionalAmount;
        protected List<NotionalPeriod.NotionalPeriodBuilder> notionalAmountSchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
        protected List<NotionalPeriod.NotionalPeriodBuilder> notionalQuantitySchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
        protected ISOCurrencyCodeEnum notionalCurrency;
        protected BigDecimal totalNotionalQuantity;
        protected BigDecimal fixedRate;
        protected ISOCurrencyCodeEnum settlementCurrency;
        protected PriceFormat.PriceFormatBuilder spread;
        protected PriceNotationEnum spreadNotation;
        protected ISOCurrencyCodeEnum spreadCurrency;
        protected String quantityUnitOfMeasure;
        protected Direction2Enum direction2;

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public PeriodicPayment.PeriodicPaymentBuilder getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        public PeriodicPayment.PeriodicPaymentBuilder getOrCreatePeriodicPayment() {
            PeriodicPayment.PeriodicPaymentBuilder result = this.periodicPayment != null ? this.periodicPayment : (this.periodicPayment = PeriodicPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalAmountSchedule() {
            return this.notionalAmountSchedule;
        }

        @Override
        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalAmountSchedule(int index) {
            if (this.notionalAmountSchedule == null) {
                this.notionalAmountSchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            }
            return (NotionalPeriod.NotionalPeriodBuilder)this.getIndex(this.notionalAmountSchedule, index, () -> {
                NotionalPeriod.NotionalPeriodBuilder newNotionalAmountSchedule = NotionalPeriod.builder();
                return newNotionalAmountSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalQuantitySchedule() {
            return this.notionalQuantitySchedule;
        }

        @Override
        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalQuantitySchedule(int index) {
            if (this.notionalQuantitySchedule == null) {
                this.notionalQuantitySchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            }
            return (NotionalPeriod.NotionalPeriodBuilder)this.getIndex(this.notionalQuantitySchedule, index, () -> {
                NotionalPeriod.NotionalPeriodBuilder newNotionalQuantitySchedule = NotionalPeriod.builder();
                return newNotionalQuantitySchedule;
            });
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public ISOCurrencyCodeEnum getNotionalCurrency() {
            return this.notionalCurrency;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public BigDecimal getTotalNotionalQuantity() {
            return this.totalNotionalQuantity;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public ISOCurrencyCodeEnum getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public PriceFormat.PriceFormatBuilder getSpread() {
            return this.spread;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreateSpread() {
            PriceFormat.PriceFormatBuilder result = this.spread != null ? this.spread : (this.spread = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public PriceNotationEnum getSpreadNotation() {
            return this.spreadNotation;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public ISOCurrencyCodeEnum getSpreadCurrency() {
            return this.spreadCurrency;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public String getQuantityUnitOfMeasure() {
            return this.quantityUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public Direction2Enum getDirection2() {
            return this.direction2;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public LegV1Builder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public LegV1Builder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public LegV1Builder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule) {
            if (_notionalAmountSchedule != null) {
                this.notionalAmountSchedule.add(_notionalAmountSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LegV1Builder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule, int idx) {
            this.getIndex(this.notionalAmountSchedule, idx, () -> _notionalAmountSchedule.toBuilder());
            return this;
        }

        @Override
        public LegV1Builder addNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            if (notionalAmountSchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalAmountSchedules) {
                    this.notionalAmountSchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountSchedule")
        public LegV1Builder setNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            this.notionalAmountSchedule = notionalAmountSchedules == null ? new ArrayList<NotionalPeriod.NotionalPeriodBuilder>() : (List)notionalAmountSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public LegV1Builder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule) {
            if (_notionalQuantitySchedule != null) {
                this.notionalQuantitySchedule.add(_notionalQuantitySchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LegV1Builder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule, int idx) {
            this.getIndex(this.notionalQuantitySchedule, idx, () -> _notionalQuantitySchedule.toBuilder());
            return this;
        }

        @Override
        public LegV1Builder addNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            if (notionalQuantitySchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalQuantitySchedules) {
                    this.notionalQuantitySchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantitySchedule")
        public LegV1Builder setNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            this.notionalQuantitySchedule = notionalQuantitySchedules == null ? new ArrayList<NotionalPeriod.NotionalPeriodBuilder>() : (List)notionalQuantitySchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public LegV1Builder setNotionalCurrency(ISOCurrencyCodeEnum _notionalCurrency) {
            this.notionalCurrency = _notionalCurrency == null ? null : _notionalCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public LegV1Builder setTotalNotionalQuantity(BigDecimal _totalNotionalQuantity) {
            this.totalNotionalQuantity = _totalNotionalQuantity == null ? null : _totalNotionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public LegV1Builder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public LegV1Builder setSettlementCurrency(ISOCurrencyCodeEnum _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public LegV1Builder setSpread(PriceFormat _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public LegV1Builder setSpreadNotation(PriceNotationEnum _spreadNotation) {
            this.spreadNotation = _spreadNotation == null ? null : _spreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public LegV1Builder setSpreadCurrency(ISOCurrencyCodeEnum _spreadCurrency) {
            this.spreadCurrency = _spreadCurrency == null ? null : _spreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public LegV1Builder setQuantityUnitOfMeasure(String _quantityUnitOfMeasure) {
            this.quantityUnitOfMeasure = _quantityUnitOfMeasure == null ? null : _quantityUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public LegV1Builder setDirection2(Direction2Enum _direction2) {
            this.direction2 = _direction2 == null ? null : _direction2;
            return this;
        }

        @Override
        public LegV1 build() {
            return new LegV1Impl(this);
        }

        @Override
        public LegV1Builder toBuilder() {
            return this;
        }

        @Override
        public LegV1Builder prune() {
            if (this.periodicPayment != null && !this.periodicPayment.prune().hasData()) {
                this.periodicPayment = null;
            }
            this.notionalAmountSchedule = this.notionalAmountSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantitySchedule = this.notionalQuantitySchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.spread != null && !this.spread.prune().hasData()) {
                this.spread = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriodicPayment() != null && this.getPeriodicPayment().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null) {
                return true;
            }
            if (this.getNotionalAmountSchedule() != null && this.getNotionalAmountSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalQuantitySchedule() != null && this.getNotionalQuantitySchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalCurrency() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantity() != null) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getSettlementCurrency() != null) {
                return true;
            }
            if (this.getSpread() != null && this.getSpread().hasData()) {
                return true;
            }
            if (this.getSpreadNotation() != null) {
                return true;
            }
            if (this.getSpreadCurrency() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasure() != null) {
                return true;
            }
            return this.getDirection2() != null;
        }

        public LegV1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegV1Builder o = (LegV1Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodicPayment(), (RosettaModelObjectBuilder)o.getPeriodicPayment(), this::setPeriodicPayment);
            merger.mergeRosetta(this.getNotionalAmountSchedule(), o.getNotionalAmountSchedule(), this::getOrCreateNotionalAmountSchedule);
            merger.mergeRosetta(this.getNotionalQuantitySchedule(), o.getNotionalQuantitySchedule(), this::getOrCreateNotionalQuantitySchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpread(), (RosettaModelObjectBuilder)o.getSpread(), this::setSpread);
            merger.mergeBasic((Object)this.getNotionalAmount(), (Object)o.getNotionalAmount(), this::setNotionalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrency(), (Object)o.getNotionalCurrency(), this::setNotionalCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantity(), (Object)o.getTotalNotionalQuantity(), this::setTotalNotionalQuantity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrency(), (Object)o.getSettlementCurrency(), this::setSettlementCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotation(), (Object)o.getSpreadNotation(), this::setSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadCurrency(), (Object)o.getSpreadCurrency(), this::setSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasure(), (Object)o.getQuantityUnitOfMeasure(), this::setQuantityUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2(), (Object)o.getDirection2(), this::setDirection2, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegV1 _that = this.getType().cast(o);
            if (!Objects.equals(this.periodicPayment, _that.getPeriodicPayment())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountSchedule, _that.getNotionalAmountSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantitySchedule, _that.getNotionalQuantitySchedule())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrency, _that.getNotionalCurrency())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantity, _that.getTotalNotionalQuantity())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.spreadNotation, (Object)_that.getSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrency, _that.getSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasure, _that.getQuantityUnitOfMeasure())) {
                return false;
            }
            return Objects.equals((Object)this.direction2, (Object)_that.getDirection2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountSchedule != null ? this.notionalAmountSchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantitySchedule != null ? this.notionalQuantitySchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrency != null ? this.notionalCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantity != null ? this.totalNotionalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotation != null ? ((Object)((Object)this.spreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrency != null ? this.spreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasure != null ? this.quantityUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.direction2 != null ? ((Object)((Object)this.direction2)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegV1Builder {periodicPayment=" + String.valueOf(this.periodicPayment) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + ", notionalAmountSchedule=" + String.valueOf(this.notionalAmountSchedule) + ", notionalQuantitySchedule=" + String.valueOf(this.notionalQuantitySchedule) + ", notionalCurrency=" + String.valueOf(this.notionalCurrency) + ", totalNotionalQuantity=" + String.valueOf(this.totalNotionalQuantity) + ", fixedRate=" + String.valueOf(this.fixedRate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", spread=" + String.valueOf(this.spread) + ", spreadNotation=" + String.valueOf((Object)this.spreadNotation) + ", spreadCurrency=" + String.valueOf(this.spreadCurrency) + ", quantityUnitOfMeasure=" + this.quantityUnitOfMeasure + ", direction2=" + String.valueOf((Object)this.direction2) + "}";
        }
    }

    public static interface LegV1Builder
    extends LegV1,
    RosettaModelObjectBuilder {
        public PeriodicPayment.PeriodicPaymentBuilder getOrCreatePeriodicPayment();

        @Override
        public PeriodicPayment.PeriodicPaymentBuilder getPeriodicPayment();

        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalAmountSchedule(int var1);

        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalAmountSchedule();

        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalQuantitySchedule(int var1);

        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalQuantitySchedule();

        public PriceFormat.PriceFormatBuilder getOrCreateSpread();

        @Override
        public PriceFormat.PriceFormatBuilder getSpread();

        public LegV1Builder setPeriodicPayment(PeriodicPayment var1);

        public LegV1Builder setNotionalAmount(BigDecimal var1);

        public LegV1Builder addNotionalAmountSchedule(NotionalPeriod var1);

        public LegV1Builder addNotionalAmountSchedule(NotionalPeriod var1, int var2);

        public LegV1Builder addNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        public LegV1Builder setNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        public LegV1Builder addNotionalQuantitySchedule(NotionalPeriod var1);

        public LegV1Builder addNotionalQuantitySchedule(NotionalPeriod var1, int var2);

        public LegV1Builder addNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        public LegV1Builder setNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        public LegV1Builder setNotionalCurrency(ISOCurrencyCodeEnum var1);

        public LegV1Builder setTotalNotionalQuantity(BigDecimal var1);

        public LegV1Builder setFixedRate(BigDecimal var1);

        public LegV1Builder setSettlementCurrency(ISOCurrencyCodeEnum var1);

        public LegV1Builder setSpread(PriceFormat var1);

        public LegV1Builder setSpreadNotation(PriceNotationEnum var1);

        public LegV1Builder setSpreadCurrency(ISOCurrencyCodeEnum var1);

        public LegV1Builder setQuantityUnitOfMeasure(String var1);

        public LegV1Builder setDirection2(Direction2Enum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.PeriodicPaymentBuilder.class, this.getPeriodicPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.PriceFormatBuilder.class, this.getSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public LegV1Builder prune();
    }

    public static class LegV1Impl
    implements LegV1 {
        private final PeriodicPayment periodicPayment;
        private final BigDecimal notionalAmount;
        private final List<? extends NotionalPeriod> notionalAmountSchedule;
        private final List<? extends NotionalPeriod> notionalQuantitySchedule;
        private final ISOCurrencyCodeEnum notionalCurrency;
        private final BigDecimal totalNotionalQuantity;
        private final BigDecimal fixedRate;
        private final ISOCurrencyCodeEnum settlementCurrency;
        private final PriceFormat spread;
        private final PriceNotationEnum spreadNotation;
        private final ISOCurrencyCodeEnum spreadCurrency;
        private final String quantityUnitOfMeasure;
        private final Direction2Enum direction2;

        protected LegV1Impl(LegV1Builder builder) {
            this.periodicPayment = Optional.ofNullable(builder.getPeriodicPayment()).map(f -> f.build()).orElse(null);
            this.notionalAmount = builder.getNotionalAmount();
            this.notionalAmountSchedule = Optional.ofNullable(builder.getNotionalAmountSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalQuantitySchedule = Optional.ofNullable(builder.getNotionalQuantitySchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalCurrency = builder.getNotionalCurrency();
            this.totalNotionalQuantity = builder.getTotalNotionalQuantity();
            this.fixedRate = builder.getFixedRate();
            this.settlementCurrency = builder.getSettlementCurrency();
            this.spread = Optional.ofNullable(builder.getSpread()).map(f -> f.build()).orElse(null);
            this.spreadNotation = builder.getSpreadNotation();
            this.spreadCurrency = builder.getSpreadCurrency();
            this.quantityUnitOfMeasure = builder.getQuantityUnitOfMeasure();
            this.direction2 = builder.getDirection2();
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public PeriodicPayment getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public List<? extends NotionalPeriod> getNotionalAmountSchedule() {
            return this.notionalAmountSchedule;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public List<? extends NotionalPeriod> getNotionalQuantitySchedule() {
            return this.notionalQuantitySchedule;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public ISOCurrencyCodeEnum getNotionalCurrency() {
            return this.notionalCurrency;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public BigDecimal getTotalNotionalQuantity() {
            return this.totalNotionalQuantity;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public ISOCurrencyCodeEnum getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public PriceFormat getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public PriceNotationEnum getSpreadNotation() {
            return this.spreadNotation;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public ISOCurrencyCodeEnum getSpreadCurrency() {
            return this.spreadCurrency;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public String getQuantityUnitOfMeasure() {
            return this.quantityUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public Direction2Enum getDirection2() {
            return this.direction2;
        }

        @Override
        public LegV1 build() {
            return this;
        }

        @Override
        public LegV1Builder toBuilder() {
            LegV1Builder builder = LegV1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegV1Builder builder) {
            Optional.ofNullable(this.getPeriodicPayment()).ifPresent(builder::setPeriodicPayment);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getNotionalAmountSchedule()).ifPresent(builder::setNotionalAmountSchedule);
            Optional.ofNullable(this.getNotionalQuantitySchedule()).ifPresent(builder::setNotionalQuantitySchedule);
            Optional.ofNullable(this.getNotionalCurrency()).ifPresent(builder::setNotionalCurrency);
            Optional.ofNullable(this.getTotalNotionalQuantity()).ifPresent(builder::setTotalNotionalQuantity);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getSpreadNotation()).ifPresent(builder::setSpreadNotation);
            Optional.ofNullable(this.getSpreadCurrency()).ifPresent(builder::setSpreadCurrency);
            Optional.ofNullable(this.getQuantityUnitOfMeasure()).ifPresent(builder::setQuantityUnitOfMeasure);
            Optional.ofNullable(this.getDirection2()).ifPresent(builder::setDirection2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegV1 _that = this.getType().cast(o);
            if (!Objects.equals(this.periodicPayment, _that.getPeriodicPayment())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountSchedule, _that.getNotionalAmountSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantitySchedule, _that.getNotionalQuantitySchedule())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrency, _that.getNotionalCurrency())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantity, _that.getTotalNotionalQuantity())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.spreadNotation, (Object)_that.getSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrency, _that.getSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasure, _that.getQuantityUnitOfMeasure())) {
                return false;
            }
            return Objects.equals((Object)this.direction2, (Object)_that.getDirection2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountSchedule != null ? this.notionalAmountSchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantitySchedule != null ? this.notionalQuantitySchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrency != null ? this.notionalCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantity != null ? this.totalNotionalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotation != null ? ((Object)((Object)this.spreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrency != null ? this.spreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasure != null ? this.quantityUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.direction2 != null ? ((Object)((Object)this.direction2)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegV1 {periodicPayment=" + String.valueOf(this.periodicPayment) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + ", notionalAmountSchedule=" + String.valueOf(this.notionalAmountSchedule) + ", notionalQuantitySchedule=" + String.valueOf(this.notionalQuantitySchedule) + ", notionalCurrency=" + String.valueOf(this.notionalCurrency) + ", totalNotionalQuantity=" + String.valueOf(this.totalNotionalQuantity) + ", fixedRate=" + String.valueOf(this.fixedRate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", spread=" + String.valueOf(this.spread) + ", spreadNotation=" + String.valueOf((Object)this.spreadNotation) + ", spreadCurrency=" + String.valueOf(this.spreadCurrency) + ", quantityUnitOfMeasure=" + this.quantityUnitOfMeasure + ", direction2=" + String.valueOf((Object)this.direction2) + "}";
        }
    }
}

