/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.collateral.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.Party;
import cdm.product.collateral.CollateralMarginTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableCollateral;
import drr.regulation.common.functions.GetCollateralBalancesForMarginType;
import drr.regulation.common.functions.GetMarginCurrency;
import javax.inject.Inject;

@ImplementedBy(value=VariationMarginCollectedByReportingCounterpartyCurrencyDefault.class)
public abstract class VariationMarginCollectedByReportingCounterpartyCurrency
implements RosettaFunction {
    @Inject
    protected GetCollateralBalancesForMarginType getCollateralBalancesForMarginType;
    @Inject
    protected GetMarginCurrency getMarginCurrency;

    public ISOCurrencyCodeEnum evaluate(ReportableCollateral reportableCollateral, Party reportingCounterparty) {
        ISOCurrencyCodeEnum marginCurrency = this.doEvaluate(reportableCollateral, reportingCounterparty);
        return marginCurrency;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(ReportableCollateral var1, Party var2);

    public static class VariationMarginCollectedByReportingCounterpartyCurrencyDefault
    extends VariationMarginCollectedByReportingCounterpartyCurrency {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(ReportableCollateral reportableCollateral, Party reportingCounterparty) {
            ISOCurrencyCodeEnum marginCurrency = null;
            return this.assignOutput(marginCurrency, reportableCollateral, reportingCounterparty);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum marginCurrency, ReportableCollateral reportableCollateral, Party reportingCounterparty) {
            marginCurrency = this.getMarginCurrency.evaluate(MapperC.of(this.getCollateralBalancesForMarginType.evaluate(reportableCollateral, CollateralMarginTypeEnum.VARIATION_MARGIN)).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPayerReceiver", collateralBalance -> collateralBalance.getPayerReceiver()).map("getReceiverPartyReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverPartyReference()).map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), (Mapper)MapperS.of((Object)reportingCounterparty), (CardinalityOperator)CardinalityOperator.All).get()).getMulti());
            return marginCurrency;
        }
    }
}

