/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateBasisRuleDefault.class)
public abstract class ExchangeRateBasisRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateBasisRuleDefault
    extends ExchangeRateBasisRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperC thenArg0 = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperC.of(this.contract_StrikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
            MapperS thenArg1 = thenArg0.last();
            FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)thenArg1.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()).get();
            FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)thenArg1.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)thenArg1.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                FieldWithMetaString fieldWithMetaString3 = (FieldWithMetaString)thenArg1.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                ifThenElseResult = MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString), (Mapper)MapperS.of((Object)"/")), (Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString));
            } else {
                ifThenElseResult = MapperS.ofNull();
            }
            output = (String)ifThenElseResult.get();
            return output;
        }
    }
}

