/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import drr.standards.iosco.cde.base.price.functions.FormatToBaseOne18Rate;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateRuleDefault
    extends ExchangeRateRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperC thenArg0 = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperC.of(this.contract_StrikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
            MapperS thenArg1 = thenArg0.last();
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

