/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SpreadLeg2RuleDefault.class)
public abstract class SpreadLeg2Rule
implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected TradeForEvent tradeForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public PriceSchedule evaluate(TransactionReportInstruction input) {
        PriceSchedule output;
        PriceSchedule.PriceScheduleBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction var1);

    public static class SpreadLeg2RuleDefault
    extends SpreadLeg2Rule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
            PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
            return this.assignOutput(output, input);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.tradeForEvent.evaluate(input));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.isIRSwaption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.interestRateLeg2.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
                }
                Boolean boolean1 = this.isCommoditySwap.evaluate((Product)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)this.commodityLeg2.evaluate((Product)item.get())).map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
                }
                return MapperS.of((Object)this.interestRateLeg2.evaluate((Product)item.get())).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
            });
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)thenArg2.mapSingleToItem(item -> item.map("getPrice", spreadSchedule -> spreadSchedule.getPrice())).get();
            output = referenceWithMetaPriceSchedule == null ? null : (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaPriceSchedule.getValue());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

