/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.regnosys.rosetta.formatting2.IFormattedResourceAcceptor;
import com.regnosys.rosetta.formatting2.ResourceFormatterService;
import com.regnosys.rosetta.rosetta.Import;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.utils.ImportManagementService;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.util.ITextRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtextResourceFormatter
implements ResourceFormatterService {
    private static Logger LOGGER = LoggerFactory.getLogger(XtextResourceFormatter.class);
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private Provider<IFormatter2> iFormatter2Provider;
    @Inject
    private Provider<TextRegionAccessBuilder> regionBuilderProvider;
    @Inject
    private Serializer serializer;
    @Inject
    private ImportManagementService importManagementService;

    @Override
    public void formatCollection(Collection<Resource> resources, ITypedPreferenceValues preferences, IFormattedResourceAcceptor acceptor) {
        resources.stream().forEach(resource -> {
            if (resource instanceof XtextResource) {
                String formattedContents = this.formatXtextResource((XtextResource)resource, preferences);
                if (formattedContents != null) {
                    acceptor.accept((Resource)resource, formattedContents);
                }
            } else {
                LOGGER.debug("Resource is not of type XtextResource and is skipped: " + String.valueOf(resource.getURI()));
            }
        });
    }

    @Override
    public String formatXtextResource(XtextResource resource, ITypedPreferenceValues preferences) {
        ArrayList<ITextReplacement> replacements;
        if (!resource.getAllContents().hasNext()) {
            LOGGER.debug("Resource " + String.valueOf(resource.getURI()) + " is empty.");
            return null;
        }
        LOGGER.debug("Formatting file at location " + String.valueOf(resource.getURI()));
        FormatterRequest req = (FormatterRequest)this.formatterRequestProvider.get();
        req.setPreferences(preferences);
        IFormatter2 formatter = (IFormatter2)this.iFormatter2Provider.get();
        ITextRegionAccess regionAccess = this.getRegionAccess(resource);
        req.setTextRegionAccess(regionAccess);
        try {
            replacements = formatter.format(req);
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in " + String.valueOf(resource.getURI()) + ": " + e.getMessage(), (Throwable)e);
            replacements = new ArrayList<ITextReplacement>();
        }
        ITextReplacement importsReplacement = this.formattedImportsReplacement(resource, regionAccess);
        if (importsReplacement != null) {
            replacements.add(importsReplacement);
        }
        ITextRegionRewriter regionRewriter = regionAccess.getRewriter();
        String formattedString = regionRewriter.renderToString(regionAccess.regionForDocument(), replacements);
        return formattedString;
    }

    public ITextReplacement formattedImportsReplacement(XtextResource resource, ITextRegionAccess regionAccess) {
        RosettaModel model = (RosettaModel)resource.getContents().get(0);
        ITextRegion importsRegion = this.getImportsTextRegion((List<Import>)model.getImports());
        if (importsRegion == null) {
            return null;
        }
        this.importManagementService.cleanupImports(model);
        String sortedImportsText = this.importManagementService.toString((List<Import>)model.getImports());
        return regionAccess.getRewriter().createReplacement(importsRegion.getOffset(), importsRegion.getLength(), sortedImportsText);
    }

    private ITextRegionAccess getRegionAccess(XtextResource resource) {
        if (resource.getParseResult() != null) {
            TextRegionAccessBuilder regionBuilder = (TextRegionAccessBuilder)this.regionBuilderProvider.get();
            return regionBuilder.forNodeModel(resource).create();
        }
        EObject root = (EObject)resource.getContents().get(0);
        return this.serializer.serializeToRegions(root);
    }

    private ITextRegion getImportsTextRegion(List<Import> imports) {
        if (imports.isEmpty()) {
            return null;
        }
        Import firstImport = imports.get(0);
        Import lastImport = imports.get(imports.size() - 1);
        ITextRegion firstRegion = NodeModelUtils.getNode((EObject)firstImport).getTextRegion();
        ITextRegion lastRegion = NodeModelUtils.getNode((EObject)lastImport).getTextRegion();
        return firstRegion.merge(lastRegion);
    }
}

