/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java;

import com.regnosys.rosetta.generator.GenerationException;
import com.regnosys.rosetta.generator.java.JavaGeneratorErrorHandler;
import com.regnosys.rosetta.generator.java.scoping.JavaClassScope;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.util.CancelIndicator;

public abstract class JavaClassGenerator<T, C extends JavaTypeDeclaration<?>> {
    protected abstract Stream<? extends T> streamObjects(RosettaModel var1);

    protected abstract EObject getSource(T var1);

    protected abstract C createTypeRepresentation(T var1);

    protected abstract String generate(T var1, C var2, String var3, JavaClassScope var4, JavaGeneratorErrorHandler var5);

    protected JavaGeneratorErrorHandler createErrorHandler(Consumer<GenerationException> addGenerationException, T object, RosettaModel model) {
        return new ErrorHandler(addGenerationException, object, model);
    }

    public List<GenerationException> generateClasses(RosettaModel model, String version, IFileSystemAccess2 fsa, CancelIndicator cancelIndicator) {
        ArrayList<GenerationException> generationExceptions = new ArrayList<GenerationException>();
        this.streamObjects(model).forEach(object -> {
            if (cancelIndicator.isCanceled()) {
                throw new CancellationException();
            }
            JavaGeneratorErrorHandler errorHandler = this.createErrorHandler(generationExceptions::add, object, model);
            try {
                C typeRepresentation = this.createTypeRepresentation(object);
                JavaClassScope classScope = JavaClassScope.createAndRegisterIdentifier(typeRepresentation);
                String javaFileCode = this.generate(object, typeRepresentation, version, classScope, errorHandler);
                fsa.generateFile(typeRepresentation.getCanonicalName().withForwardSlashes() + ".java", (CharSequence)javaFileCode);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (GenerationException e) {
                generationExceptions.add(e);
            }
            catch (Exception e) {
                errorHandler.handleError(e);
            }
        });
        return generationExceptions;
    }

    private class ErrorHandler
    implements JavaGeneratorErrorHandler {
        private final Consumer<GenerationException> addGenerationException;
        private final T object;
        private final RosettaModel model;

        public ErrorHandler(Consumer<GenerationException> addGenerationException, T object, RosettaModel model) {
            this.addGenerationException = addGenerationException;
            this.object = object;
            this.model = model;
        }

        private URI getURI() {
            return this.object == null ? this.model.eResource().getURI() : JavaClassGenerator.this.getSource(this.object).eResource().getURI();
        }

        @Override
        public void handleError(String message) {
            this.handleError(message, JavaClassGenerator.this.getSource(this.object));
        }

        @Override
        public void handleError(String message, EObject source) {
            this.addGenerationException.accept(new GenerationException(message, this.getURI(), source));
        }

        @Override
        public void handleError(String message, Throwable cause) {
            this.handleError(message, JavaClassGenerator.this.getSource(this.object), cause);
        }

        @Override
        public void handleError(String message, EObject source, Throwable cause) {
            this.addGenerationException.accept(new GenerationException(message, this.getURI(), source, cause));
        }

        @Override
        public void handleError(Throwable cause) {
            this.handleError(JavaClassGenerator.this.getSource(this.object), cause);
        }

        @Override
        public void handleError(EObject source, Throwable cause) {
            this.handleError(cause.getMessage(), source, cause);
        }
    }
}

