/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.function;

import com.regnosys.rosetta.generator.java.scoping.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.scoping.JavaMethodScope;
import com.regnosys.rosetta.generator.java.scoping.JavaStatementScope;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class AliasUtil {
    @Inject
    private ExpressionHelper expressionHelper;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private CardinalityProvider cardinalityProvider;
    @Inject
    private JavaTypeTranslator typeTranslator;
    @Inject
    private JavaTypeUtil typeUtil;
    @Inject
    private JavaIdentifierRepresentationService identifierService;

    public JavaReferenceType getReturnType(RShortcut alias) {
        if (this.requiresOutput(alias)) {
            RMetaAnnotatedType rtype = this.typeProvider.getRMetaAnnotatedType(alias.getExpression());
            return this.toMultiBuilderType(rtype, this.cardinalityProvider.isMulti(alias.getExpression()));
        }
        JavaGenericTypeDeclaration<MapperS<?>> wrapper = this.typeUtil.MAPPER_S;
        if (this.cardinalityProvider.isMulti(alias.getExpression())) {
            wrapper = this.typeUtil.MAPPER_C;
        }
        JavaParameterizedType<MapperS<?>> result = this.typeUtil.wrapExtendsIfNotFinal(wrapper, alias.getExpression());
        return result;
    }

    public StringConcatenationClient getParameters(final RShortcut alias, final JavaMethodScope scope) {
        final RFunction func = alias.getFunction();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                if (AliasUtil.this.requiresOutput(alias)) {
                    RAttribute output = func.getOutput();
                    JavaReferenceType outputParameterType = AliasUtil.this.toMultiBuilderType(output.getRMetaAnnotatedType(), output.isMulti());
                    target.append((Object)outputParameterType);
                    target.append((Object)" ");
                    target.append((Object)scope.getIdentifierOrThrow(output));
                    if (!func.getInputs().isEmpty()) {
                        target.append((Object)", ");
                    }
                }
                for (int i = 0; i < func.getInputs().size(); ++i) {
                    RAttribute input = func.getInputs().get(i);
                    JavaClass<?> inputParameterType = AliasUtil.this.typeTranslator.toMetaJavaType(input);
                    target.append(inputParameterType);
                    target.append((Object)" ");
                    target.append((Object)scope.getIdentifierOrThrow(input));
                    if (i >= func.getInputs().size() - 1) continue;
                    target.append((Object)", ");
                }
            }
        };
    }

    public StringConcatenationClient getArguments(final RShortcut alias, final JavaStatementScope scope) {
        final RFunction func = alias.getFunction();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                if (AliasUtil.this.requiresOutput(alias)) {
                    RAttribute output = func.getOutput();
                    target.append((Object)scope.getIdentifierOrThrow(output));
                    target.append((Object)".toBuilder()");
                    if (!func.getInputs().isEmpty()) {
                        target.append((Object)", ");
                    }
                }
                for (int i = 0; i < func.getInputs().size(); ++i) {
                    RAttribute input = func.getInputs().get(i);
                    target.append((Object)scope.getIdentifierOrThrow(input));
                    if (i >= func.getInputs().size() - 1) continue;
                    target.append((Object)", ");
                }
            }
        };
    }

    public boolean requiresOutput(RShortcut alias) {
        return this.expressionHelper.usesOutputParameter(alias.getExpression());
    }

    private JavaReferenceType toBuilderType(RMetaAnnotatedType type) {
        JavaClass<?> javaType = this.typeTranslator.toJavaReferenceType(type);
        if (javaType instanceof JavaPojoInterface) {
            JavaPojoInterface pojoInterface = (JavaPojoInterface)javaType;
            return pojoInterface.toBuilderInterface();
        }
        return javaType;
    }

    private JavaReferenceType toMultiBuilderType(RMetaAnnotatedType type, boolean isMulti) {
        JavaReferenceType builderType = this.toBuilderType(type);
        if (isMulti) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)builderType);
        }
        return builderType;
    }
}

