/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.interpreter;

import com.regnosys.rosetta.interpreter.RosettaValueWithNaturalOrder;
import com.rosetta.model.lib.RosettaNumber;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class RosettaNumberValue
extends RosettaValueWithNaturalOrder<RosettaNumber> {
    private final RosettaNumber scale;

    public RosettaNumberValue(List<RosettaNumber> items, RosettaNumber scale) {
        super(items, RosettaNumber.class);
        Validate.isTrue((scale.compareTo(RosettaNumber.ZERO) > 0 ? 1 : 0) != 0);
        this.scale = scale;
    }

    public RosettaNumberValue(List<RosettaNumber> items) {
        this(items, RosettaNumber.ONE);
    }

    public static RosettaNumberValue of(RosettaNumber ... items) {
        return RosettaNumberValue.withScale(RosettaNumber.ONE, items);
    }

    public static RosettaNumberValue withScale(RosettaNumber scale, RosettaNumber ... items) {
        return new RosettaNumberValue(List.of(items), scale);
    }

    @Override
    public String toString() {
        if (this.scale.equals((Object)RosettaNumber.ONE)) {
            return super.toString();
        }
        return "(scaled x" + String.valueOf(this.scale) + ")[" + this.getItems().stream().map(i -> i.multiply(this.scale).toString()).collect(Collectors.joining(", ")) + "]";
    }
}

