/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RObject;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelSymbolId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RDataType
extends RType
implements RObject {
    private final Data data;
    private RDataType superType = null;
    private ModelSymbolId symbolId = null;
    private Map<String, RAttribute> ownAttributes = null;
    private Map<String, RAttribute> allAttributes = null;
    private List<RMetaAttribute> metaAttributes = null;
    private final ModelIdProvider modelIdProvider;
    private final RObjectFactory objectFactory;
    private final RosettaTypeProvider typeProvider;

    public RDataType(Data data, ModelIdProvider modelIdProvider, RObjectFactory objectFactory, RosettaTypeProvider typeProvider) {
        this.data = data;
        this.modelIdProvider = modelIdProvider;
        this.objectFactory = objectFactory;
        this.typeProvider = typeProvider;
    }

    @Override
    public Data getEObject() {
        return this.data;
    }

    public ModelSymbolId getSymbolId() {
        if (this.symbolId == null) {
            this.symbolId = this.modelIdProvider.getSymbolId(this.data);
        }
        return this.symbolId;
    }

    public List<RMetaAttribute> getMetaAttributes() {
        if (this.metaAttributes == null) {
            this.metaAttributes = this.typeProvider.getRMetaAttributes((List<AnnotationRef>)this.data.getAnnotations());
        }
        return this.metaAttributes;
    }

    public boolean hasMetaAttribute(String name) {
        return this.getMetaAttributes().stream().anyMatch(m -> m.getName().equals(name));
    }

    public RDataType getSuperType() {
        if (this.data.hasSuperType()) {
            if (this.superType == null) {
                this.superType = new RDataType(this.data.getSuperType(), this.modelIdProvider, this.objectFactory, this.typeProvider);
            }
            return this.superType;
        }
        return null;
    }

    public List<RDataType> getAllSuperTypes() {
        LinkedHashSet<RDataType> reversedResult = new LinkedHashSet<RDataType>();
        this.doGetAllSuperTypes(this, reversedResult);
        List result = reversedResult.stream().collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(result);
        return result;
    }

    private void doGetAllSuperTypes(RDataType current, Set<RDataType> superTypes) {
        RDataType s;
        if (superTypes.add(current) && (s = current.getSuperType()) != null) {
            this.doGetAllSuperTypes(s, superTypes);
        }
    }

    public Collection<RAttribute> getOwnAttributes() {
        return this.getOwnAttributesAsMap().values();
    }

    public RAttribute getOwnAttributeByName(String name) {
        return this.getOwnAttributesAsMap().get(name);
    }

    private Map<String, RAttribute> getOwnAttributesAsMap() {
        if (this.ownAttributes == null) {
            this.ownAttributes = this.data.getAttributes().stream().map(s -> this.objectFactory.buildRAttributeWithEnclosingType(this, (Attribute)s)).collect(Collectors.toMap(a -> a.getName(), a -> a, (a1, a2) -> a1, LinkedHashMap::new));
        }
        return this.ownAttributes;
    }

    public Collection<RAttribute> getAllAttributes() {
        return this.getAllAttributesAsMap().values();
    }

    public RAttribute getAttributeByName(String name) {
        return this.getAllAttributesAsMap().get(name);
    }

    private Map<String, RAttribute> getAllAttributesAsMap() {
        if (this.allAttributes == null) {
            this.allAttributes = this.buildAllAttributesMap(new HashSet<RDataType>());
        }
        return this.allAttributes;
    }

    private Map<String, RAttribute> buildAllAttributesMap(Set<RDataType> visited) {
        if (!visited.add(this)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, RAttribute> result = new LinkedHashMap<String, RAttribute>();
        RDataType superType = this.getSuperType();
        if (superType != null) {
            if (superType.allAttributes == null) {
                superType.allAttributes = superType.buildAllAttributesMap(visited);
            }
            result.putAll(superType.getAllAttributesAsMap());
        }
        result.putAll(this.getOwnAttributesAsMap());
        return Collections.unmodifiableMap(result);
    }

    public int hashCode() {
        return 31 + (this.data == null ? 0 : this.data.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RDataType other = (RDataType)object;
        return Objects.equals(this.data, other.data);
    }
}

