/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.names;

import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.validation.names.ClusterScope;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.LocalUniqueNameContext;

@Singleton
public class ClusterScopes {
    @Inject
    private GlobalClusterScope GLOBAL;

    public ClusterScope global() {
        return this.GLOBAL;
    }

    public <Parent, Child extends RosettaNamed> ClusterScope local(Class<Child> childClass, final Function<Child, Parent> getParent, final Function<Parent, Iterable<Child>> getChildren) {
        return new LocalClusterScope<Parent, Child>(childClass){

            @Override
            protected Parent getParent(Child child) {
                return getParent.apply(child);
            }

            @Override
            protected Iterable<Child> getChildren(Parent parent) {
                return (Iterable)getChildren.apply(parent);
            }
        };
    }

    @Singleton
    private static class GlobalClusterScope
    implements ClusterScope {
        @Inject
        private IResourceDescriptionsProvider indexAccess;

        private GlobalClusterScope() {
        }

        @Override
        public Function<IEObjectDescription, ISelectable> getScope(Resource resource, EClass clusterType) {
            IResourceDescriptions index = this.getIndex(resource);
            return description -> index;
        }

        protected IResourceDescriptions getIndex(Resource resource) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet == null) {
                return null;
            }
            return this.indexAccess.getResourceDescriptions(resourceSet);
        }
    }

    private static abstract class LocalClusterScope<Parent, Child extends RosettaNamed>
    implements ClusterScope {
        private final Class<Child> childClass;
        private final Map<LocalScopeKey<Parent>, ISelectable> localValidationScopes = new HashMap<LocalScopeKey<Parent>, ISelectable>();

        public LocalClusterScope(Class<Child> childClass) {
            this.childClass = childClass;
        }

        protected abstract Parent getParent(Child var1);

        protected abstract Iterable<Child> getChildren(Parent var1);

        @Override
        public boolean acceptCluster(IEObjectDescription description, EClass clusterType) {
            return this.getParentFromChildDescription(description) != null;
        }

        @Override
        public Function<IEObjectDescription, ISelectable> getScope(Resource resource, EClass clusterType) {
            return description -> {
                Parent parent = this.getParentFromChildDescription((IEObjectDescription)description);
                LocalScopeKey<Parent> key = new LocalScopeKey<Parent>(parent, clusterType);
                return this.localValidationScopes.computeIfAbsent(key, k -> new PatchedLocalUniqueNameContext(this.getChildren(parent), RosettaNamed::getName, CancelIndicator.NullImpl).getValidationScope((IEObjectDescription)description, clusterType));
            };
        }

        private Parent getParentFromChildDescription(IEObjectDescription description) {
            EObject object = description.getEObjectOrProxy();
            if (!this.childClass.isInstance(object)) {
                return null;
            }
            RosettaNamed child = (RosettaNamed)this.childClass.cast(object);
            return this.getParent(child);
        }

        private record LocalScopeKey<Parent>(Parent container, EClass clusterType) {
        }

        private static class PatchedLocalUniqueNameContext
        extends LocalUniqueNameContext {
            public <T extends EObject> PatchedLocalUniqueNameContext(Iterable<T> objects, Function<T, String> nameFunction, CancelIndicator ci) {
                super(objects, nameFunction, ci);
            }

            public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
                return super.getExportedObjects(type, QualifiedName.create((String)name.getLastSegment()), ignoreCase);
            }
        }
    }
}

