/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.AppendDateToList;
import cdm.base.datetime.functions.IsBusinessDay;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GenerateDateListDefault.class)
public abstract class GenerateDateList
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected AppendDateToList appendDateToList;
    @Inject
    protected GenerateDateList generateDateList;
    @Inject
    protected IsBusinessDay isBusinessDay;

    public List<Date> evaluate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
        List<Date> dateList = this.doEvaluate(startDate, endDate, businessCenters);
        return dateList;
    }

    protected abstract List<Date> doEvaluate(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Boolean> active(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Boolean> isGoodBusinessDay(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract MapperS<Date> priorDate(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract MapperC<Date> priorList(Date var1, Date var2, List<BusinessCenterEnum> var3);

    protected abstract MapperC<Date> newList(Date var1, Date var2, List<BusinessCenterEnum> var3);

    public static class GenerateDateListDefault
    extends GenerateDateList {
        @Override
        protected List<Date> doEvaluate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            ArrayList<Date> dateList = new ArrayList<Date>();
            return this.assignOutput(dateList, startDate, endDate, businessCenters);
        }

        protected List<Date> assignOutput(List<Date> dateList, Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            if (((Boolean)this.active(startDate, endDate, businessCenters).getOrDefault((Object)false)).booleanValue()) {
                dateList.addAll(this.newList(startDate, endDate, businessCenters).getMulti());
            } else {
                dateList.addAll(Collections.emptyList());
            }
            return dateList;
        }

        @Override
        protected MapperS<Boolean> active(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)startDate), (Mapper)MapperS.of((Object)endDate), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Boolean> isGoodBusinessDay(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.isBusinessDay.evaluate(endDate, businessCenters));
        }

        @Override
        protected MapperS<Date> priorDate(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)this.addBusinessDays.evaluate(endDate, -1, businessCenters));
        }

        @Override
        protected MapperC<Date> priorList(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            return MapperC.of(this.generateDateList.evaluate(startDate, (Date)this.priorDate(startDate, endDate, businessCenters).get(), businessCenters));
        }

        @Override
        protected MapperC<Date> newList(Date startDate, Date endDate, List<BusinessCenterEnum> businessCenters) {
            if (((Boolean)this.isGoodBusinessDay(startDate, endDate, businessCenters).getOrDefault((Object)false)).booleanValue()) {
                return MapperC.of(this.appendDateToList.evaluate(this.priorList(startDate, endDate, businessCenters).getMulti(), endDate));
            }
            return this.priorList(startDate, endDate, businessCenters);
        }
    }
}

