/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.CommodityProductDefinition;
import cdm.base.staticdata.asset.common.DeliveryDateParameters;
import cdm.base.staticdata.asset.common.Listing;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.meta.CommodityMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.QuotationSideEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Commodity", builder=CommodityBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Commodity", model="cdm", builder=CommodityBuilderImpl.class, version="5.31.0")
public interface Commodity
extends Listing {
    public static final CommodityMeta metaData = new CommodityMeta();

    public CommodityProductDefinition getCommodityProductDefinition();

    public QuotationSideEnum getPriceQuoteType();

    public DeliveryDateParameters getDeliveryDateReference();

    public String getDescription();

    @Override
    public Commodity build();

    @Override
    public CommodityBuilder toBuilder();

    public static CommodityBuilder builder() {
        return new CommodityBuilderImpl();
    }

    default public RosettaMetaData<? extends Commodity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Commodity> getType() {
        return Commodity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.class, this.getProductTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityProductDefinition"), processor, CommodityProductDefinition.class, this.getCommodityProductDefinition(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceQuoteType"), QuotationSideEnum.class, (Object)this.getPriceQuoteType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateReference"), processor, DeliveryDateParameters.class, this.getDeliveryDateReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityBuilderImpl
    extends Listing.ListingBuilderImpl
    implements CommodityBuilder {
        protected CommodityProductDefinition.CommodityProductDefinitionBuilder commodityProductDefinition;
        protected QuotationSideEnum priceQuoteType;
        protected DeliveryDateParameters.DeliveryDateParametersBuilder deliveryDateReference;
        protected String description;

        @Override
        @RosettaAttribute(value="commodityProductDefinition")
        @RuneAttribute(value="commodityProductDefinition")
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getCommodityProductDefinition() {
            return this.commodityProductDefinition;
        }

        @Override
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getOrCreateCommodityProductDefinition() {
            CommodityProductDefinition.CommodityProductDefinitionBuilder result = this.commodityProductDefinition != null ? this.commodityProductDefinition : (this.commodityProductDefinition = CommodityProductDefinition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuoteType", isRequired=true)
        @RuneAttribute(value="priceQuoteType", isRequired=true)
        public QuotationSideEnum getPriceQuoteType() {
            return this.priceQuoteType;
        }

        @Override
        @RosettaAttribute(value="deliveryDateReference")
        @RuneAttribute(value="deliveryDateReference")
        public DeliveryDateParameters.DeliveryDateParametersBuilder getDeliveryDateReference() {
            return this.deliveryDateReference;
        }

        @Override
        public DeliveryDateParameters.DeliveryDateParametersBuilder getOrCreateDeliveryDateReference() {
            DeliveryDateParameters.DeliveryDateParametersBuilder result = this.deliveryDateReference != null ? this.deliveryDateReference : (this.deliveryDateReference = DeliveryDateParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy) {
            if (_productTaxonomy != null) {
                this.productTaxonomy.add(_productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy, int idx) {
            this.getIndex(this.productTaxonomy, idx, () -> _productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productTaxonomy")
        public CommodityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier, int idx) {
            this.getIndex(this.productIdentifier, idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier, int idx) {
            this.getOrCreateProductIdentifier(idx).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public CommodityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CommodityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public CommodityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public CommodityBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public CommodityBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public CommodityBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityProductDefinition")
        @RuneAttribute(value="commodityProductDefinition")
        public CommodityBuilder setCommodityProductDefinition(CommodityProductDefinition _commodityProductDefinition) {
            this.commodityProductDefinition = _commodityProductDefinition == null ? null : _commodityProductDefinition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuoteType", isRequired=true)
        @RuneAttribute(value="priceQuoteType", isRequired=true)
        public CommodityBuilder setPriceQuoteType(QuotationSideEnum _priceQuoteType) {
            this.priceQuoteType = _priceQuoteType == null ? null : _priceQuoteType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryDateReference")
        @RuneAttribute(value="deliveryDateReference")
        public CommodityBuilder setDeliveryDateReference(DeliveryDateParameters _deliveryDateReference) {
            this.deliveryDateReference = _deliveryDateReference == null ? null : _deliveryDateReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public CommodityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        public Commodity build() {
            return new CommodityImpl(this);
        }

        @Override
        public CommodityBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBuilder prune() {
            super.prune();
            if (this.commodityProductDefinition != null && !this.commodityProductDefinition.prune().hasData()) {
                this.commodityProductDefinition = null;
            }
            if (this.deliveryDateReference != null && !this.deliveryDateReference.prune().hasData()) {
                this.deliveryDateReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCommodityProductDefinition() != null && this.getCommodityProductDefinition().hasData()) {
                return true;
            }
            if (this.getPriceQuoteType() != null) {
                return true;
            }
            if (this.getDeliveryDateReference() != null && this.getDeliveryDateReference().hasData()) {
                return true;
            }
            return this.getDescription() != null;
        }

        @Override
        public CommodityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityBuilder o = (CommodityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityProductDefinition(), (RosettaModelObjectBuilder)o.getCommodityProductDefinition(), this::setCommodityProductDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateReference(), (RosettaModelObjectBuilder)o.getDeliveryDateReference(), this::setDeliveryDateReference);
            merger.mergeBasic((Object)this.getPriceQuoteType(), (Object)o.getPriceQuoteType(), this::setPriceQuoteType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            if (!Objects.equals(this.commodityProductDefinition, _that.getCommodityProductDefinition())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceQuoteType, (Object)_that.getPriceQuoteType())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateReference, _that.getDeliveryDateReference())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductDefinition != null ? this.commodityProductDefinition.hashCode() : 0);
            _result = 31 * _result + (this.priceQuoteType != null ? ((Object)((Object)this.priceQuoteType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateReference != null ? this.deliveryDateReference.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBuilder {commodityProductDefinition=" + this.commodityProductDefinition + ", priceQuoteType=" + (Object)((Object)this.priceQuoteType) + ", deliveryDateReference=" + this.deliveryDateReference + ", description=" + this.description + '}' + " " + super.toString();
        }
    }

    public static interface CommodityBuilder
    extends Commodity,
    Listing.ListingBuilder {
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getOrCreateCommodityProductDefinition();

        @Override
        public CommodityProductDefinition.CommodityProductDefinitionBuilder getCommodityProductDefinition();

        public DeliveryDateParameters.DeliveryDateParametersBuilder getOrCreateDeliveryDateReference();

        @Override
        public DeliveryDateParameters.DeliveryDateParametersBuilder getDeliveryDateReference();

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public CommodityBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public CommodityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public CommodityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public CommodityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public CommodityBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public CommodityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public CommodityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public CommodityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public CommodityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public CommodityBuilder setExchange(LegalEntity var1);

        @Override
        public CommodityBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public CommodityBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public CommodityBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public CommodityBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        public CommodityBuilder setCommodityProductDefinition(CommodityProductDefinition var1);

        public CommodityBuilder setPriceQuoteType(QuotationSideEnum var1);

        public CommodityBuilder setDeliveryDateReference(DeliveryDateParameters var1);

        public CommodityBuilder setDescription(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getProductTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityProductDefinition"), processor, CommodityProductDefinition.CommodityProductDefinitionBuilder.class, this.getCommodityProductDefinition(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceQuoteType"), QuotationSideEnum.class, (Object)this.getPriceQuoteType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateReference"), processor, DeliveryDateParameters.DeliveryDateParametersBuilder.class, this.getDeliveryDateReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommodityBuilder prune();
    }

    public static class CommodityImpl
    extends Listing.ListingImpl
    implements Commodity {
        private final CommodityProductDefinition commodityProductDefinition;
        private final QuotationSideEnum priceQuoteType;
        private final DeliveryDateParameters deliveryDateReference;
        private final String description;

        protected CommodityImpl(CommodityBuilder builder) {
            super(builder);
            this.commodityProductDefinition = Optional.ofNullable(builder.getCommodityProductDefinition()).map(f -> f.build()).orElse(null);
            this.priceQuoteType = builder.getPriceQuoteType();
            this.deliveryDateReference = Optional.ofNullable(builder.getDeliveryDateReference()).map(f -> f.build()).orElse(null);
            this.description = builder.getDescription();
        }

        @Override
        @RosettaAttribute(value="commodityProductDefinition")
        @RuneAttribute(value="commodityProductDefinition")
        public CommodityProductDefinition getCommodityProductDefinition() {
            return this.commodityProductDefinition;
        }

        @Override
        @RosettaAttribute(value="priceQuoteType", isRequired=true)
        @RuneAttribute(value="priceQuoteType", isRequired=true)
        public QuotationSideEnum getPriceQuoteType() {
            return this.priceQuoteType;
        }

        @Override
        @RosettaAttribute(value="deliveryDateReference")
        @RuneAttribute(value="deliveryDateReference")
        public DeliveryDateParameters getDeliveryDateReference() {
            return this.deliveryDateReference;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public Commodity build() {
            return this;
        }

        @Override
        public CommodityBuilder toBuilder() {
            CommodityBuilder builder = Commodity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCommodityProductDefinition()).ifPresent(builder::setCommodityProductDefinition);
            Optional.ofNullable(this.getPriceQuoteType()).ifPresent(builder::setPriceQuoteType);
            Optional.ofNullable(this.getDeliveryDateReference()).ifPresent(builder::setDeliveryDateReference);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            if (!Objects.equals(this.commodityProductDefinition, _that.getCommodityProductDefinition())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceQuoteType, (Object)_that.getPriceQuoteType())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDateReference, _that.getDeliveryDateReference())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductDefinition != null ? this.commodityProductDefinition.hashCode() : 0);
            _result = 31 * _result + (this.priceQuoteType != null ? ((Object)((Object)this.priceQuoteType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateReference != null ? this.deliveryDateReference.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Commodity {commodityProductDefinition=" + this.commodityProductDefinition + ", priceQuoteType=" + (Object)((Object)this.priceQuoteType) + ", deliveryDateReference=" + this.deliveryDateReference + ", description=" + this.description + '}' + " " + super.toString();
        }
    }
}

