/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.meta.ListingMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.party.LegalEntity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Listing", builder=ListingBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Listing", model="cdm", builder=ListingBuilderImpl.class, version="5.31.0")
public interface Listing
extends ProductBase {
    public static final ListingMeta metaData = new ListingMeta();

    public LegalEntity getExchange();

    public List<? extends LegalEntity> getRelatedExchange();

    @Override
    public Listing build();

    @Override
    public ListingBuilder toBuilder();

    public static ListingBuilder builder() {
        return new ListingBuilderImpl();
    }

    default public RosettaMetaData<? extends Listing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Listing> getType() {
        return Listing.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.class, this.getProductTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
    }

    public static class ListingBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements ListingBuilder {
        protected LegalEntity.LegalEntityBuilder exchange;
        protected List<LegalEntity.LegalEntityBuilder> relatedExchange = new ArrayList<LegalEntity.LegalEntityBuilder>();

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public LegalEntity.LegalEntityBuilder getExchange() {
            return this.exchange;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateExchange() {
            LegalEntity.LegalEntityBuilder result = this.exchange != null ? this.exchange : (this.exchange = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public List<? extends LegalEntity.LegalEntityBuilder> getRelatedExchange() {
            return this.relatedExchange;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateRelatedExchange(int index) {
            if (this.relatedExchange == null) {
                this.relatedExchange = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.relatedExchange, index, () -> {
                LegalEntity.LegalEntityBuilder newRelatedExchange = LegalEntity.builder();
                return newRelatedExchange;
            });
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public ListingBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy) {
            if (_productTaxonomy != null) {
                this.productTaxonomy.add(_productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public ListingBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy, int idx) {
            this.getIndex(this.productTaxonomy, idx, () -> _productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public ListingBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productTaxonomy")
        public ListingBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public ListingBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ListingBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier, int idx) {
            this.getIndex(this.productIdentifier, idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ListingBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ListingBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier, int idx) {
            this.getOrCreateProductIdentifier(idx).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ListingBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public ListingBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ListingBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public ListingBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public ListingBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public ListingBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public ListingBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public ListingBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public ListingBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Listing build() {
            return new ListingImpl(this);
        }

        @Override
        public ListingBuilder toBuilder() {
            return this;
        }

        @Override
        public ListingBuilder prune() {
            super.prune();
            if (this.exchange != null && !this.exchange.prune().hasData()) {
                this.exchange = null;
            }
            this.relatedExchange = this.relatedExchange.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExchange() != null && this.getExchange().hasData()) {
                return true;
            }
            return this.getRelatedExchange() != null && this.getRelatedExchange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ListingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ListingBuilder o = (ListingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchange(), (RosettaModelObjectBuilder)o.getExchange(), this::setExchange);
            merger.mergeRosetta(this.getRelatedExchange(), o.getRelatedExchange(), this::getOrCreateRelatedExchange);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Listing _that = (Listing)this.getType().cast(o);
            if (!Objects.equals(this.exchange, _that.getExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedExchange, _that.getRelatedExchange());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchange != null ? this.exchange.hashCode() : 0);
            _result = 31 * _result + (this.relatedExchange != null ? this.relatedExchange.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ListingBuilder {exchange=" + this.exchange + ", relatedExchange=" + this.relatedExchange + '}' + " " + super.toString();
        }
    }

    public static interface ListingBuilder
    extends Listing,
    ProductBase.ProductBaseBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateExchange();

        @Override
        public LegalEntity.LegalEntityBuilder getExchange();

        public LegalEntity.LegalEntityBuilder getOrCreateRelatedExchange(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getRelatedExchange();

        @Override
        public ListingBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public ListingBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public ListingBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public ListingBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public ListingBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public ListingBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public ListingBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public ListingBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public ListingBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public ListingBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public ListingBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public ListingBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        public ListingBuilder setExchange(LegalEntity var1);

        public ListingBuilder addRelatedExchange(LegalEntity var1);

        public ListingBuilder addRelatedExchange(LegalEntity var1, int var2);

        public ListingBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        public ListingBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getProductTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
        }

        @Override
        public ListingBuilder prune();
    }

    public static class ListingImpl
    extends ProductBase.ProductBaseImpl
    implements Listing {
        private final LegalEntity exchange;
        private final List<? extends LegalEntity> relatedExchange;

        protected ListingImpl(ListingBuilder builder) {
            super(builder);
            this.exchange = Optional.ofNullable(builder.getExchange()).map(f -> f.build()).orElse(null);
            this.relatedExchange = Optional.ofNullable(builder.getRelatedExchange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public LegalEntity getExchange() {
            return this.exchange;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public List<? extends LegalEntity> getRelatedExchange() {
            return this.relatedExchange;
        }

        @Override
        public Listing build() {
            return this;
        }

        @Override
        public ListingBuilder toBuilder() {
            ListingBuilder builder = Listing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ListingBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchange()).ifPresent(builder::setExchange);
            Optional.ofNullable(this.getRelatedExchange()).ifPresent(builder::setRelatedExchange);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Listing _that = (Listing)this.getType().cast(o);
            if (!Objects.equals(this.exchange, _that.getExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedExchange, _that.getRelatedExchange());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchange != null ? this.exchange.hashCode() : 0);
            _result = 31 * _result + (this.relatedExchange != null ? this.relatedExchange.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Listing {exchange=" + this.exchange + ", relatedExchange=" + this.relatedExchange + '}' + " " + super.toString();
        }
    }
}

