/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.credit;

import cdm.base.staticdata.asset.credit.NotDomesticCurrency;
import cdm.base.staticdata.asset.credit.ObligationCategoryEnum;
import cdm.base.staticdata.asset.credit.SpecifiedCurrency;
import cdm.base.staticdata.asset.credit.meta.ObligationsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Obligations", builder=ObligationsBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Obligations", model="cdm", builder=ObligationsBuilderImpl.class, version="5.31.0")
public interface Obligations
extends RosettaModelObject {
    public static final ObligationsMeta metaData = new ObligationsMeta();

    public ObligationCategoryEnum getCategory();

    public Boolean getNotSubordinated();

    public SpecifiedCurrency getSpecifiedCurrency();

    public Boolean getNotSovereignLender();

    public NotDomesticCurrency getNotDomesticCurrency();

    public Boolean getNotDomesticLaw();

    public Boolean getListed();

    public Boolean getNotDomesticIssuance();

    public Boolean getFullFaithAndCreditObLiability();

    public Boolean getGeneralFundObligationLiability();

    public Boolean getRevenueObligationLiability();

    public Boolean getNotContingent();

    public String getExcluded();

    public String getOthReferenceEntityObligations();

    public FieldWithMetaString getDesignatedPriority();

    public Boolean getCashSettlementOnly();

    public Boolean getDeliveryOfCommitments();

    public Boolean getContinuity();

    public Obligations build();

    public ObligationsBuilder toBuilder();

    public static ObligationsBuilder builder() {
        return new ObligationsBuilderImpl();
    }

    default public RosettaMetaData<? extends Obligations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Obligations> getType() {
        return Obligations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("designatedPriority"), processor, FieldWithMetaString.class, this.getDesignatedPriority(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cashSettlementOnly"), Boolean.class, (Object)this.getCashSettlementOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryOfCommitments"), Boolean.class, (Object)this.getDeliveryOfCommitments(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("continuity"), Boolean.class, (Object)this.getContinuity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ObligationsBuilderImpl
    implements ObligationsBuilder {
        protected ObligationCategoryEnum category;
        protected Boolean notSubordinated;
        protected SpecifiedCurrency.SpecifiedCurrencyBuilder specifiedCurrency;
        protected Boolean notSovereignLender;
        protected NotDomesticCurrency.NotDomesticCurrencyBuilder notDomesticCurrency;
        protected Boolean notDomesticLaw;
        protected Boolean listed;
        protected Boolean notDomesticIssuance;
        protected Boolean fullFaithAndCreditObLiability;
        protected Boolean generalFundObligationLiability;
        protected Boolean revenueObligationLiability;
        protected Boolean notContingent;
        protected String excluded;
        protected String othReferenceEntityObligations;
        protected FieldWithMetaString.FieldWithMetaStringBuilder designatedPriority;
        protected Boolean cashSettlementOnly;
        protected Boolean deliveryOfCommitments;
        protected Boolean continuity;

        @Override
        @RosettaAttribute(value="category", isRequired=true)
        @RuneAttribute(value="category", isRequired=true)
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency() {
            SpecifiedCurrency.SpecifiedCurrencyBuilder result = this.specifiedCurrency != null ? this.specifiedCurrency : (this.specifiedCurrency = SpecifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency() {
            NotDomesticCurrency.NotDomesticCurrencyBuilder result = this.notDomesticCurrency != null ? this.notDomesticCurrency : (this.notDomesticCurrency = NotDomesticCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        @RosettaAttribute(value="designatedPriority")
        @RuneAttribute(value="designatedPriority")
        public FieldWithMetaString.FieldWithMetaStringBuilder getDesignatedPriority() {
            return this.designatedPriority;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateDesignatedPriority() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.designatedPriority != null ? this.designatedPriority : (this.designatedPriority = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlementOnly")
        @RuneAttribute(value="cashSettlementOnly")
        public Boolean getCashSettlementOnly() {
            return this.cashSettlementOnly;
        }

        @Override
        @RosettaAttribute(value="deliveryOfCommitments")
        @RuneAttribute(value="deliveryOfCommitments")
        public Boolean getDeliveryOfCommitments() {
            return this.deliveryOfCommitments;
        }

        @Override
        @RosettaAttribute(value="continuity")
        @RuneAttribute(value="continuity")
        public Boolean getContinuity() {
            return this.continuity;
        }

        @Override
        @RosettaAttribute(value="category", isRequired=true)
        @RuneAttribute(value="category", isRequired=true)
        public ObligationsBuilder setCategory(ObligationCategoryEnum _category) {
            this.category = _category == null ? null : _category;
            return this;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public ObligationsBuilder setNotSubordinated(Boolean _notSubordinated) {
            this.notSubordinated = _notSubordinated == null ? null : _notSubordinated;
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public ObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency _specifiedCurrency) {
            this.specifiedCurrency = _specifiedCurrency == null ? null : _specifiedCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public ObligationsBuilder setNotSovereignLender(Boolean _notSovereignLender) {
            this.notSovereignLender = _notSovereignLender == null ? null : _notSovereignLender;
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public ObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency _notDomesticCurrency) {
            this.notDomesticCurrency = _notDomesticCurrency == null ? null : _notDomesticCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public ObligationsBuilder setNotDomesticLaw(Boolean _notDomesticLaw) {
            this.notDomesticLaw = _notDomesticLaw == null ? null : _notDomesticLaw;
            return this;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public ObligationsBuilder setListed(Boolean _listed) {
            this.listed = _listed == null ? null : _listed;
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public ObligationsBuilder setNotDomesticIssuance(Boolean _notDomesticIssuance) {
            this.notDomesticIssuance = _notDomesticIssuance == null ? null : _notDomesticIssuance;
            return this;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public ObligationsBuilder setFullFaithAndCreditObLiability(Boolean _fullFaithAndCreditObLiability) {
            this.fullFaithAndCreditObLiability = _fullFaithAndCreditObLiability == null ? null : _fullFaithAndCreditObLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public ObligationsBuilder setGeneralFundObligationLiability(Boolean _generalFundObligationLiability) {
            this.generalFundObligationLiability = _generalFundObligationLiability == null ? null : _generalFundObligationLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public ObligationsBuilder setRevenueObligationLiability(Boolean _revenueObligationLiability) {
            this.revenueObligationLiability = _revenueObligationLiability == null ? null : _revenueObligationLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public ObligationsBuilder setNotContingent(Boolean _notContingent) {
            this.notContingent = _notContingent == null ? null : _notContingent;
            return this;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public ObligationsBuilder setExcluded(String _excluded) {
            this.excluded = _excluded == null ? null : _excluded;
            return this;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public ObligationsBuilder setOthReferenceEntityObligations(String _othReferenceEntityObligations) {
            this.othReferenceEntityObligations = _othReferenceEntityObligations == null ? null : _othReferenceEntityObligations;
            return this;
        }

        @Override
        @RosettaAttribute(value="designatedPriority")
        @RuneAttribute(value="designatedPriority")
        public ObligationsBuilder setDesignatedPriority(FieldWithMetaString _designatedPriority) {
            this.designatedPriority = _designatedPriority == null ? null : _designatedPriority.toBuilder();
            return this;
        }

        @Override
        public ObligationsBuilder setDesignatedPriorityValue(String _designatedPriority) {
            this.getOrCreateDesignatedPriority().setValue(_designatedPriority);
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlementOnly")
        @RuneAttribute(value="cashSettlementOnly")
        public ObligationsBuilder setCashSettlementOnly(Boolean _cashSettlementOnly) {
            this.cashSettlementOnly = _cashSettlementOnly == null ? null : _cashSettlementOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryOfCommitments")
        @RuneAttribute(value="deliveryOfCommitments")
        public ObligationsBuilder setDeliveryOfCommitments(Boolean _deliveryOfCommitments) {
            this.deliveryOfCommitments = _deliveryOfCommitments == null ? null : _deliveryOfCommitments;
            return this;
        }

        @Override
        @RosettaAttribute(value="continuity")
        @RuneAttribute(value="continuity")
        public ObligationsBuilder setContinuity(Boolean _continuity) {
            this.continuity = _continuity == null ? null : _continuity;
            return this;
        }

        @Override
        public Obligations build() {
            return new ObligationsImpl(this);
        }

        @Override
        public ObligationsBuilder toBuilder() {
            return this;
        }

        @Override
        public ObligationsBuilder prune() {
            if (this.specifiedCurrency != null && !this.specifiedCurrency.prune().hasData()) {
                this.specifiedCurrency = null;
            }
            if (this.notDomesticCurrency != null && !this.notDomesticCurrency.prune().hasData()) {
                this.notDomesticCurrency = null;
            }
            if (this.designatedPriority != null && !this.designatedPriority.prune().hasData()) {
                this.designatedPriority = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCategory() != null) {
                return true;
            }
            if (this.getNotSubordinated() != null) {
                return true;
            }
            if (this.getSpecifiedCurrency() != null && this.getSpecifiedCurrency().hasData()) {
                return true;
            }
            if (this.getNotSovereignLender() != null) {
                return true;
            }
            if (this.getNotDomesticCurrency() != null && this.getNotDomesticCurrency().hasData()) {
                return true;
            }
            if (this.getNotDomesticLaw() != null) {
                return true;
            }
            if (this.getListed() != null) {
                return true;
            }
            if (this.getNotDomesticIssuance() != null) {
                return true;
            }
            if (this.getFullFaithAndCreditObLiability() != null) {
                return true;
            }
            if (this.getGeneralFundObligationLiability() != null) {
                return true;
            }
            if (this.getRevenueObligationLiability() != null) {
                return true;
            }
            if (this.getNotContingent() != null) {
                return true;
            }
            if (this.getExcluded() != null) {
                return true;
            }
            if (this.getOthReferenceEntityObligations() != null) {
                return true;
            }
            if (this.getDesignatedPriority() != null) {
                return true;
            }
            if (this.getCashSettlementOnly() != null) {
                return true;
            }
            if (this.getDeliveryOfCommitments() != null) {
                return true;
            }
            return this.getContinuity() != null;
        }

        public ObligationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObligationsBuilder o = (ObligationsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpecifiedCurrency(), (RosettaModelObjectBuilder)o.getSpecifiedCurrency(), this::setSpecifiedCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotDomesticCurrency(), (RosettaModelObjectBuilder)o.getNotDomesticCurrency(), this::setNotDomesticCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDesignatedPriority(), (RosettaModelObjectBuilder)o.getDesignatedPriority(), this::setDesignatedPriority);
            merger.mergeBasic((Object)this.getCategory(), (Object)o.getCategory(), this::setCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSubordinated(), (Object)o.getNotSubordinated(), this::setNotSubordinated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSovereignLender(), (Object)o.getNotSovereignLender(), this::setNotSovereignLender, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticLaw(), (Object)o.getNotDomesticLaw(), this::setNotDomesticLaw, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getListed(), (Object)o.getListed(), this::setListed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticIssuance(), (Object)o.getNotDomesticIssuance(), this::setNotDomesticIssuance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFullFaithAndCreditObLiability(), (Object)o.getFullFaithAndCreditObLiability(), this::setFullFaithAndCreditObLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGeneralFundObligationLiability(), (Object)o.getGeneralFundObligationLiability(), this::setGeneralFundObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRevenueObligationLiability(), (Object)o.getRevenueObligationLiability(), this::setRevenueObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotContingent(), (Object)o.getNotContingent(), this::setNotContingent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcluded(), (Object)o.getExcluded(), this::setExcluded, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOthReferenceEntityObligations(), (Object)o.getOthReferenceEntityObligations(), this::setOthReferenceEntityObligations, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCashSettlementOnly(), (Object)o.getCashSettlementOnly(), this::setCashSettlementOnly, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryOfCommitments(), (Object)o.getDeliveryOfCommitments(), this::setDeliveryOfCommitments, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContinuity(), (Object)o.getContinuity(), this::setContinuity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Obligations _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            if (!Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations())) {
                return false;
            }
            if (!Objects.equals(this.designatedPriority, _that.getDesignatedPriority())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementOnly, _that.getCashSettlementOnly())) {
                return false;
            }
            if (!Objects.equals(this.deliveryOfCommitments, _that.getDeliveryOfCommitments())) {
                return false;
            }
            return Objects.equals(this.continuity, _that.getContinuity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            _result = 31 * _result + (this.designatedPriority != null ? this.designatedPriority.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementOnly != null ? this.cashSettlementOnly.hashCode() : 0);
            _result = 31 * _result + (this.deliveryOfCommitments != null ? this.deliveryOfCommitments.hashCode() : 0);
            _result = 31 * _result + (this.continuity != null ? this.continuity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObligationsBuilder {category=" + (Object)((Object)this.category) + ", notSubordinated=" + this.notSubordinated + ", specifiedCurrency=" + this.specifiedCurrency + ", notSovereignLender=" + this.notSovereignLender + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticLaw=" + this.notDomesticLaw + ", listed=" + this.listed + ", notDomesticIssuance=" + this.notDomesticIssuance + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", revenueObligationLiability=" + this.revenueObligationLiability + ", notContingent=" + this.notContingent + ", excluded=" + this.excluded + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + ", designatedPriority=" + this.designatedPriority + ", cashSettlementOnly=" + this.cashSettlementOnly + ", deliveryOfCommitments=" + this.deliveryOfCommitments + ", continuity=" + this.continuity + '}';
        }
    }

    public static interface ObligationsBuilder
    extends Obligations,
    RosettaModelObjectBuilder {
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency();

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency();

        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency();

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateDesignatedPriority();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getDesignatedPriority();

        public ObligationsBuilder setCategory(ObligationCategoryEnum var1);

        public ObligationsBuilder setNotSubordinated(Boolean var1);

        public ObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency var1);

        public ObligationsBuilder setNotSovereignLender(Boolean var1);

        public ObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency var1);

        public ObligationsBuilder setNotDomesticLaw(Boolean var1);

        public ObligationsBuilder setListed(Boolean var1);

        public ObligationsBuilder setNotDomesticIssuance(Boolean var1);

        public ObligationsBuilder setFullFaithAndCreditObLiability(Boolean var1);

        public ObligationsBuilder setGeneralFundObligationLiability(Boolean var1);

        public ObligationsBuilder setRevenueObligationLiability(Boolean var1);

        public ObligationsBuilder setNotContingent(Boolean var1);

        public ObligationsBuilder setExcluded(String var1);

        public ObligationsBuilder setOthReferenceEntityObligations(String var1);

        public ObligationsBuilder setDesignatedPriority(FieldWithMetaString var1);

        public ObligationsBuilder setDesignatedPriorityValue(String var1);

        public ObligationsBuilder setCashSettlementOnly(Boolean var1);

        public ObligationsBuilder setDeliveryOfCommitments(Boolean var1);

        public ObligationsBuilder setContinuity(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.SpecifiedCurrencyBuilder.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.NotDomesticCurrencyBuilder.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("designatedPriority"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getDesignatedPriority(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cashSettlementOnly"), Boolean.class, (Object)this.getCashSettlementOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryOfCommitments"), Boolean.class, (Object)this.getDeliveryOfCommitments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("continuity"), Boolean.class, (Object)this.getContinuity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ObligationsBuilder prune();
    }

    public static class ObligationsImpl
    implements Obligations {
        private final ObligationCategoryEnum category;
        private final Boolean notSubordinated;
        private final SpecifiedCurrency specifiedCurrency;
        private final Boolean notSovereignLender;
        private final NotDomesticCurrency notDomesticCurrency;
        private final Boolean notDomesticLaw;
        private final Boolean listed;
        private final Boolean notDomesticIssuance;
        private final Boolean fullFaithAndCreditObLiability;
        private final Boolean generalFundObligationLiability;
        private final Boolean revenueObligationLiability;
        private final Boolean notContingent;
        private final String excluded;
        private final String othReferenceEntityObligations;
        private final FieldWithMetaString designatedPriority;
        private final Boolean cashSettlementOnly;
        private final Boolean deliveryOfCommitments;
        private final Boolean continuity;

        protected ObligationsImpl(ObligationsBuilder builder) {
            this.category = builder.getCategory();
            this.notSubordinated = builder.getNotSubordinated();
            this.specifiedCurrency = Optional.ofNullable(builder.getSpecifiedCurrency()).map(f -> f.build()).orElse(null);
            this.notSovereignLender = builder.getNotSovereignLender();
            this.notDomesticCurrency = Optional.ofNullable(builder.getNotDomesticCurrency()).map(f -> f.build()).orElse(null);
            this.notDomesticLaw = builder.getNotDomesticLaw();
            this.listed = builder.getListed();
            this.notDomesticIssuance = builder.getNotDomesticIssuance();
            this.fullFaithAndCreditObLiability = builder.getFullFaithAndCreditObLiability();
            this.generalFundObligationLiability = builder.getGeneralFundObligationLiability();
            this.revenueObligationLiability = builder.getRevenueObligationLiability();
            this.notContingent = builder.getNotContingent();
            this.excluded = builder.getExcluded();
            this.othReferenceEntityObligations = builder.getOthReferenceEntityObligations();
            this.designatedPriority = Optional.ofNullable(builder.getDesignatedPriority()).map(f -> f.build()).orElse(null);
            this.cashSettlementOnly = builder.getCashSettlementOnly();
            this.deliveryOfCommitments = builder.getDeliveryOfCommitments();
            this.continuity = builder.getContinuity();
        }

        @Override
        @RosettaAttribute(value="category", isRequired=true)
        @RuneAttribute(value="category", isRequired=true)
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public SpecifiedCurrency getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public NotDomesticCurrency getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        @RosettaAttribute(value="designatedPriority")
        @RuneAttribute(value="designatedPriority")
        public FieldWithMetaString getDesignatedPriority() {
            return this.designatedPriority;
        }

        @Override
        @RosettaAttribute(value="cashSettlementOnly")
        @RuneAttribute(value="cashSettlementOnly")
        public Boolean getCashSettlementOnly() {
            return this.cashSettlementOnly;
        }

        @Override
        @RosettaAttribute(value="deliveryOfCommitments")
        @RuneAttribute(value="deliveryOfCommitments")
        public Boolean getDeliveryOfCommitments() {
            return this.deliveryOfCommitments;
        }

        @Override
        @RosettaAttribute(value="continuity")
        @RuneAttribute(value="continuity")
        public Boolean getContinuity() {
            return this.continuity;
        }

        @Override
        public Obligations build() {
            return this;
        }

        @Override
        public ObligationsBuilder toBuilder() {
            ObligationsBuilder builder = Obligations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObligationsBuilder builder) {
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getNotSubordinated()).ifPresent(builder::setNotSubordinated);
            Optional.ofNullable(this.getSpecifiedCurrency()).ifPresent(builder::setSpecifiedCurrency);
            Optional.ofNullable(this.getNotSovereignLender()).ifPresent(builder::setNotSovereignLender);
            Optional.ofNullable(this.getNotDomesticCurrency()).ifPresent(builder::setNotDomesticCurrency);
            Optional.ofNullable(this.getNotDomesticLaw()).ifPresent(builder::setNotDomesticLaw);
            Optional.ofNullable(this.getListed()).ifPresent(builder::setListed);
            Optional.ofNullable(this.getNotDomesticIssuance()).ifPresent(builder::setNotDomesticIssuance);
            Optional.ofNullable(this.getFullFaithAndCreditObLiability()).ifPresent(builder::setFullFaithAndCreditObLiability);
            Optional.ofNullable(this.getGeneralFundObligationLiability()).ifPresent(builder::setGeneralFundObligationLiability);
            Optional.ofNullable(this.getRevenueObligationLiability()).ifPresent(builder::setRevenueObligationLiability);
            Optional.ofNullable(this.getNotContingent()).ifPresent(builder::setNotContingent);
            Optional.ofNullable(this.getExcluded()).ifPresent(builder::setExcluded);
            Optional.ofNullable(this.getOthReferenceEntityObligations()).ifPresent(builder::setOthReferenceEntityObligations);
            Optional.ofNullable(this.getDesignatedPriority()).ifPresent(builder::setDesignatedPriority);
            Optional.ofNullable(this.getCashSettlementOnly()).ifPresent(builder::setCashSettlementOnly);
            Optional.ofNullable(this.getDeliveryOfCommitments()).ifPresent(builder::setDeliveryOfCommitments);
            Optional.ofNullable(this.getContinuity()).ifPresent(builder::setContinuity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Obligations _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            if (!Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations())) {
                return false;
            }
            if (!Objects.equals(this.designatedPriority, _that.getDesignatedPriority())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementOnly, _that.getCashSettlementOnly())) {
                return false;
            }
            if (!Objects.equals(this.deliveryOfCommitments, _that.getDeliveryOfCommitments())) {
                return false;
            }
            return Objects.equals(this.continuity, _that.getContinuity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            _result = 31 * _result + (this.designatedPriority != null ? this.designatedPriority.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementOnly != null ? this.cashSettlementOnly.hashCode() : 0);
            _result = 31 * _result + (this.deliveryOfCommitments != null ? this.deliveryOfCommitments.hashCode() : 0);
            _result = 31 * _result + (this.continuity != null ? this.continuity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Obligations {category=" + (Object)((Object)this.category) + ", notSubordinated=" + this.notSubordinated + ", specifiedCurrency=" + this.specifiedCurrency + ", notSovereignLender=" + this.notSovereignLender + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticLaw=" + this.notDomesticLaw + ", listed=" + this.listed + ", notDomesticIssuance=" + this.notDomesticIssuance + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", revenueObligationLiability=" + this.revenueObligationLiability + ", notContingent=" + this.notContingent + ", excluded=" + this.excluded + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + ", designatedPriority=" + this.designatedPriority + ", cashSettlementOnly=" + this.cashSettlementOnly + ", deliveryOfCommitments=" + this.deliveryOfCommitments + ", continuity=" + this.continuity + '}';
        }
    }
}

