/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_Cashflow;
import cdm.event.common.functions.Create_CashflowTermsChangeInstruction;
import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.ScheduledTransferEnum;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_OnDemandInterestPaymentPrimitiveInstructionDefault.class)
public abstract class Create_OnDemandInterestPaymentPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_Cashflow create_Cashflow;
    @Inject
    protected Create_CashflowTermsChangeInstruction create_CashflowTermsChangeInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.exists(this.interestRatePayout(tradeState, interestAmount, settlementDate)), "Only a contractual product with a single interest rate payout can have an on-demand interest payment.");
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)interestAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (Mapper)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All), "The currency of the interest amount must match the currency of the original interest rate payout.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, interestAmount, settlementDate);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, Money var2, SettlementDate var3);

    protected abstract MapperS<? extends InterestRatePayout> interestRatePayout(TradeState var1, Money var2, SettlementDate var3);

    protected abstract MapperS<? extends Cashflow> cashflow(TradeState var1, Money var2, SettlementDate var3);

    public static class Create_OnDemandInterestPaymentPrimitiveInstructionDefault
    extends Create_OnDemandInterestPaymentPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, interestAmount, settlementDate);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            instruction = (PrimitiveInstruction.PrimitiveInstructionBuilder)this.toBuilder(PrimitiveInstruction.builder().setTermsChange(this.create_CashflowTermsChangeInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), (Cashflow)this.cashflow(tradeState, interestAmount, settlementDate).get())).build());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()));
        }

        @Override
        protected MapperS<? extends Cashflow> cashflow(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)this.create_Cashflow.evaluate((BigDecimal)MapperS.of((Object)interestAmount).map("getValue", money -> money.getValue()).get(), (FieldWithMetaString)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get(), settlementDate, (PayerReceiver)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).get(), CashflowType.builder().setCashflowType(ScheduledTransferEnum.NET_INTEREST).build(), null));
        }
    }
}

