/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=RateOfReturnDefault.class)
public abstract class RateOfReturn
implements RosettaFunction {
    public BigDecimal evaluate(PriceSchedule initialPrice, PriceSchedule finalPrice) {
        BigDecimal rateOfReturn = this.doEvaluate(initialPrice, finalPrice);
        return rateOfReturn;
    }

    protected abstract BigDecimal doEvaluate(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<BigDecimal> initialPriceValue(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<BigDecimal> finalPriceValue(PriceSchedule var1, PriceSchedule var2);

    public static class RateOfReturnDefault
    extends RateOfReturn {
        @Override
        protected BigDecimal doEvaluate(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            BigDecimal rateOfReturn = null;
            return this.assignOutput(rateOfReturn, initialPrice, finalPrice);
        }

        protected BigDecimal assignOutput(BigDecimal rateOfReturn, PriceSchedule initialPrice, PriceSchedule finalPrice) {
            rateOfReturn = ExpressionOperatorsNullSafe.exists(this.finalPriceValue(initialPrice, finalPrice)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.initialPriceValue(initialPrice, finalPrice))).andNullSafe(ExpressionOperatorsNullSafe.greaterThan(this.initialPriceValue(initialPrice, finalPrice), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperMaths.divide((Mapper)MapperMaths.subtract(this.finalPriceValue(initialPrice, finalPrice), this.initialPriceValue(initialPrice, finalPrice)), this.initialPriceValue(initialPrice, finalPrice)).get() : null;
            return rateOfReturn;
        }

        @Override
        protected MapperS<BigDecimal> initialPriceValue(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            return MapperS.of((Object)initialPrice).map("getValue", priceSchedule -> priceSchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> finalPriceValue(PriceSchedule initialPrice, PriceSchedule finalPrice) {
            return MapperS.of((Object)finalPrice).map("getValue", priceSchedule -> priceSchedule.getValue());
        }
    }
}

