/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.BillingSummary;
import cdm.event.common.RecordAmountTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BillingSummaryParentTotal")
@ImplementedBy(value=Default.class)
public interface BillingSummaryParentTotal
extends Validator<BillingSummary> {
    public static final String NAME = "BillingSummaryParentTotal";
    public static final String DEFINITION = "if summaryAmountType = RecordAmountTypeEnum -> ParentTotal then summaryTransfer -> payerReceiver exists and summaryTransfer -> payerReceiver -> payerAccountReference is absent and summaryTransfer -> payerReceiver -> receiverAccountReference is absent";

    public static class NoOp
    implements BillingSummaryParentTotal {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BillingSummary billingSummary) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BillingSummaryParentTotal {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BillingSummary billingSummary) {
            ComparisonResult result = this.executeDataRule(billingSummary);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BillingSummaryParentTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryParentTotal.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BillingSummaryParentTotal.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BillingSummary", (RosettaPath)path, (String)BillingSummaryParentTotal.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BillingSummary billingSummary) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)billingSummary).map("getSummaryAmountType", _billingSummary -> _billingSummary.getSummaryAmountType()), (Mapper)MapperS.of((Object)((Object)RecordAmountTypeEnum.PARENT_TOTAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transfer -> transfer.getPayerReceiver())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).map("getPayerAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getPayerAccountReference()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)billingSummary).map("getSummaryTransfer", _billingSummary -> _billingSummary.getSummaryTransfer()).map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).map("getReceiverAccountReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverAccountReference())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

