/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Trade;
import cdm.legaldocumentation.common.MatrixTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeDeliverableObligationsPhysicalSettlementMatrix")
@ImplementedBy(value=Default.class)
public interface TradeDeliverableObligationsPhysicalSettlementMatrix
extends Validator<Trade> {
    public static final String NAME = "TradeDeliverableObligationsPhysicalSettlementMatrix";
    public static final String DEFINITION = "if (contractDetails -> documentation -> legalAgreementIdentification -> agreementName -> contractualMatrix -> matrixType all <> MatrixTypeEnum -> CreditDerivativesPhysicalSettlementMatrix or contractDetails -> documentation -> legalAgreementIdentification -> agreementName -> contractualMatrix -> matrixType is absent) and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations exists then (tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notSubordinated exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> specifiedCurrency exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notSovereignLender exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notDomesticCurrency exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notDomesticLaw exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notContingent exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notDomesticIssuance exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> assignableLoan exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> consentRequiredLoan exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> transferable exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> maximumMaturity exists and tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> notBearer exists) and (tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> fullFaithAndCreditObLiability exists or tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> generalFundObligationLiability exists or tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> settlementTerms -> physicalSettlementTerms -> deliverableObligations -> revenueObligationLiability exists)";

    public static class NoOp
    implements TradeDeliverableObligationsPhysicalSettlementMatrix {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeDeliverableObligationsPhysicalSettlementMatrix {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeDeliverableObligationsPhysicalSettlementMatrix.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDeliverableObligationsPhysicalSettlementMatrix.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeDeliverableObligationsPhysicalSettlementMatrix.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDeliverableObligationsPhysicalSettlementMatrix.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getLegalAgreementIdentification", legalAgreement -> legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).mapC("getContractualMatrix", agreementName -> agreementName.getContractualMatrix()).map("getMatrixType", contractualMatrix -> contractualMatrix.getMatrixType()).map("Type coercion", fieldWithMetaMatrixTypeEnum -> fieldWithMetaMatrixTypeEnum.getValue()), (Mapper)MapperS.of((Object)((Object)MatrixTypeEnum.CREDIT_DERIVATIVES_PHYSICAL_SETTLEMENT_MATRIX)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getLegalAgreementIdentification", legalAgreement -> legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).mapC("getContractualMatrix", agreementName -> agreementName.getContractualMatrix()).map("getMatrixType", contractualMatrix -> contractualMatrix.getMatrixType()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotSubordinated", deliverableObligations -> deliverableObligations.getNotSubordinated())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getSpecifiedCurrency", deliverableObligations -> deliverableObligations.getSpecifiedCurrency()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotSovereignLender", deliverableObligations -> deliverableObligations.getNotSovereignLender()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotDomesticCurrency", deliverableObligations -> deliverableObligations.getNotDomesticCurrency()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotDomesticLaw", deliverableObligations -> deliverableObligations.getNotDomesticLaw()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotContingent", deliverableObligations -> deliverableObligations.getNotContingent()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotDomesticIssuance", deliverableObligations -> deliverableObligations.getNotDomesticIssuance()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getAssignableLoan", deliverableObligations -> deliverableObligations.getAssignableLoan()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getConsentRequiredLoan", deliverableObligations -> deliverableObligations.getConsentRequiredLoan()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getTransferable", deliverableObligations -> deliverableObligations.getTransferable()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getMaximumMaturity", deliverableObligations -> deliverableObligations.getMaximumMaturity()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getNotBearer", deliverableObligations -> deliverableObligations.getNotBearer()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getFullFaithAndCreditObLiability", deliverableObligations -> deliverableObligations.getFullFaithAndCreditObLiability())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getGeneralFundObligationLiability", deliverableObligations -> deliverableObligations.getGeneralFundObligationLiability()))).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getDeliverableObligations", physicalSettlementTerms -> physicalSettlementTerms.getDeliverableObligations()).map("getRevenueObligationLiability", deliverableObligations -> deliverableObligations.getRevenueObligationLiability()))));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

