/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.TransferBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TransferBaseFinancialUnitExists")
@ImplementedBy(value=Default.class)
public interface TransferBaseFinancialUnitExists
extends Validator<TransferBase> {
    public static final String NAME = "TransferBaseFinancialUnitExists";
    public static final String DEFINITION = "if observable exists then quantity -> unit -> financialUnit exists";

    public static class NoOp
    implements TransferBaseFinancialUnitExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransferBase transferBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TransferBaseFinancialUnitExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransferBase transferBase) {
            ComparisonResult result = this.executeDataRule(transferBase);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TransferBaseFinancialUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransferBase", (RosettaPath)path, (String)TransferBaseFinancialUnitExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TransferBaseFinancialUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransferBase", (RosettaPath)path, (String)TransferBaseFinancialUnitExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TransferBase transferBase) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)transferBase).map("getObservable", _transferBase -> _transferBase.getObservable())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)transferBase).map("getQuantity", _transferBase -> _transferBase.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

