/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.Measure;
import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import cdm.observable.asset.meta.MoneyMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Money", builder=MoneyBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Money", model="cdm", builder=MoneyBuilderImpl.class, version="5.31.0")
public interface Money
extends Quantity,
GlobalKey {
    public static final MoneyMeta metaData = new MoneyMeta();

    public MetaFields getMeta();

    @Override
    public Money build();

    @Override
    public MoneyBuilder toBuilder();

    public static MoneyBuilder builder() {
        return new MoneyBuilderImpl();
    }

    default public RosettaMetaData<? extends Money> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Money> getType() {
        return Money.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, UnitType.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multiplier"), processor, Measure.class, this.getMultiplier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("frequency"), processor, Frequency.class, this.getFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class MoneyBuilderImpl
    extends Quantity.QuantityBuilderImpl
    implements MoneyBuilder {
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public MoneyBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public MoneyBuilder setUnit(UnitType _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public MoneyBuilder addDatedValue(DatedValue _datedValue) {
            if (_datedValue != null) {
                this.datedValue.add(_datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public MoneyBuilder addDatedValue(DatedValue _datedValue, int idx) {
            this.getIndex(this.datedValue, idx, () -> _datedValue.toBuilder());
            return this;
        }

        @Override
        public MoneyBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datedValue")
        public MoneyBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public MoneyBuilder setMultiplier(Measure _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="frequency")
        @RuneAttribute(value="frequency")
        public MoneyBuilder setFrequency(Frequency _frequency) {
            this.frequency = _frequency == null ? null : _frequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MoneyBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Money build() {
            return new MoneyImpl(this);
        }

        @Override
        public MoneyBuilder toBuilder() {
            return this;
        }

        @Override
        public MoneyBuilder prune() {
            super.prune();
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public MoneyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MoneyBuilder o = (MoneyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MoneyBuilder {meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface MoneyBuilder
    extends Money,
    Quantity.QuantityBuilder,
    GlobalKey.GlobalKeyBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public MoneyBuilder setValue(BigDecimal var1);

        @Override
        public MoneyBuilder setUnit(UnitType var1);

        @Override
        public MoneyBuilder addDatedValue(DatedValue var1);

        @Override
        public MoneyBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public MoneyBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public MoneyBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public MoneyBuilder setMultiplier(Measure var1);

        @Override
        public MoneyBuilder setFrequency(Frequency var1);

        public MoneyBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, UnitType.UnitTypeBuilder.class, (RosettaModelObjectBuilder)this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multiplier"), processor, Measure.MeasureBuilder.class, (RosettaModelObjectBuilder)this.getMultiplier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("frequency"), processor, Frequency.FrequencyBuilder.class, (RosettaModelObjectBuilder)this.getFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public MoneyBuilder prune();
    }

    public static class MoneyImpl
    extends Quantity.QuantityImpl
    implements Money {
        private final MetaFields meta;

        protected MoneyImpl(MoneyBuilder builder) {
            super(builder);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Money build() {
            return this;
        }

        @Override
        public MoneyBuilder toBuilder() {
            MoneyBuilder builder = Money.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MoneyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Money {meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

