/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationPeriod;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=DetermineObservationPeriodDefault.class)
public abstract class DetermineObservationPeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GenerateObservationPeriod generateObservationPeriod;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public CalculationPeriodBase evaluate(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
        CalculationPeriodBase observationPeriod;
        CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriodBuilder = this.doEvaluate(adjustedCalculationPeriod, calculationParams);
        if (observationPeriodBuilder == null) {
            observationPeriod = null;
        } else {
            observationPeriod = observationPeriodBuilder.build();
            this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)observationPeriod);
        }
        return observationPeriod;
    }

    protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<? extends ObservationShiftCalculation> obsShift(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<? extends OffsetCalculation> lookback(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<? extends BusinessCenters> businessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<? extends BusinessCenters> additionalBusinessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperC<BusinessCenterEnum> allBusinessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<Integer> shift(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract MapperS<Integer> shiftDefaulted(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    public static class DetermineObservationPeriodDefault
    extends DetermineObservationPeriod {
        @Override
        protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod = CalculationPeriodBase.builder();
            return this.assignOutput(observationPeriod, adjustedCalculationPeriod, calculationParams);
        }

        protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            observationPeriod = (CalculationPeriodBase.CalculationPeriodBaseBuilder)this.toBuilder(this.generateObservationPeriod.evaluate(adjustedCalculationPeriod, this.allBusinessDays(adjustedCalculationPeriod, calculationParams).getMulti(), (Integer)this.shiftDefaulted(adjustedCalculationPeriod, calculationParams).get()));
            return Optional.ofNullable(observationPeriod).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends ObservationShiftCalculation> obsShift(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getObservationShiftCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationShiftCalculation());
        }

        @Override
        protected MapperS<? extends OffsetCalculation> lookback(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getLookbackCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getLookbackCalculation());
        }

        @Override
        protected MapperS<? extends BusinessCenters> businessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getApplicableBusinessDays", floatingRateCalculationParameters -> floatingRateCalculationParameters.getApplicableBusinessDays());
        }

        @Override
        protected MapperS<? extends BusinessCenters> additionalBusinessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return this.obsShift(adjustedCalculationPeriod, calculationParams).map("getAdditionalBusinessDays", observationShiftCalculation -> observationShiftCalculation.getAdditionalBusinessDays());
        }

        @Override
        protected MapperC<BusinessCenterEnum> allBusinessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            MapperListOfLists thenArg = MapperC.of((MapperBuilder[])new MapperBuilder[]{this.businessDays(adjustedCalculationPeriod, calculationParams), this.additionalBusinessDays(adjustedCalculationPeriod, calculationParams)}).mapItemToList(item -> MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)item.get())));
            return thenArg.flattenList();
        }

        @Override
        protected MapperS<Integer> shift(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            if (ExpressionOperatorsNullSafe.exists(this.obsShift(adjustedCalculationPeriod, calculationParams)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.obsShift(adjustedCalculationPeriod, calculationParams).map("getOffsetDays", observationShiftCalculation -> observationShiftCalculation.getOffsetDays());
            }
            if (ExpressionOperatorsNullSafe.exists(this.lookback(adjustedCalculationPeriod, calculationParams)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.lookback(adjustedCalculationPeriod, calculationParams).map("getOffsetDays", offsetCalculation -> offsetCalculation.getOffsetDays());
            }
            return MapperS.of((Object)0);
        }

        @Override
        protected MapperS<Integer> shiftDefaulted(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            if (ExpressionOperatorsNullSafe.exists(this.shift(adjustedCalculationPeriod, calculationParams)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.shift(adjustedCalculationPeriod, calculationParams);
            }
            return MapperS.of((Object)5);
        }
    }
}

